/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MethodMap {
    private static final int MORE_SPECIFIC = 0;
    private static final int LESS_SPECIFIC = 1;
    private static final int INCOMPARABLE = 2;
    Map methodByNameMap = new Hashtable();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public void add(Method method) {
        String methodName = method.getName();
        ArrayList<Method> l = this.get(methodName);
        if (l == null) {
            l = new ArrayList<Method>();
            this.methodByNameMap.put(methodName, l);
        }
        l.add(method);
    }

    public List get(String key) {
        return (List)this.methodByNameMap.get(key);
    }

    public Method find(String methodName, Object[] args) throws AmbiguousException {
        List methodList = this.get(methodName);
        if (methodList == null) {
            return null;
        }
        int l = args.length;
        Class[] classes = new Class[l];
        for (int i = 0; i < l; ++i) {
            Object arg = args[i];
            classes[i] = arg == null ? null : arg.getClass();
        }
        return MethodMap.getMostSpecific(methodList, classes);
    }

    private static Method getMostSpecific(List methods, Class[] classes) throws AmbiguousException {
        LinkedList applicables = MethodMap.getApplicables(methods, classes);
        if (applicables.isEmpty()) {
            return null;
        }
        if (applicables.size() == 1) {
            return (Method)applicables.getFirst();
        }
        LinkedList<Method> maximals = new LinkedList<Method>();
        Iterator applicable = applicables.iterator();
        while (applicable.hasNext()) {
            Method app = (Method)applicable.next();
            Class[] appArgs = app.getParameterTypes();
            boolean lessSpecific = false;
            Iterator maximal = maximals.iterator();
            while (!lessSpecific && maximal.hasNext()) {
                Method max = (Method)maximal.next();
                switch (MethodMap.moreSpecific(appArgs, max.getParameterTypes())) {
                    case 0: {
                        maximal.remove();
                        break;
                    }
                    case 1: {
                        lessSpecific = true;
                    }
                }
            }
            if (lessSpecific) continue;
            maximals.addLast(app);
        }
        if (maximals.size() > 1) {
            throw new AmbiguousException();
        }
        return (Method)maximals.getFirst();
    }

    private static int moreSpecific(Class[] c1, Class[] c2) {
        boolean c1MoreSpecific = false;
        boolean c2MoreSpecific = false;
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            c1MoreSpecific = c1MoreSpecific || MethodMap.isStrictMethodInvocationConvertible(c2[i], c1[i]);
            c2MoreSpecific = c2MoreSpecific || MethodMap.isStrictMethodInvocationConvertible(c1[i], c2[i]);
        }
        if (c1MoreSpecific) {
            if (c2MoreSpecific) {
                return 2;
            }
            return 0;
        }
        if (c2MoreSpecific) {
            return 1;
        }
        return 2;
    }

    private static LinkedList getApplicables(List methods, Class[] classes) {
        LinkedList<Method> list = new LinkedList<Method>();
        Iterator imethod = methods.iterator();
        while (imethod.hasNext()) {
            Method method = (Method)imethod.next();
            if (!MethodMap.isApplicable(method, classes)) continue;
            list.add(method);
        }
        return list;
    }

    private static boolean isApplicable(Method method, Class[] classes) {
        Class<?>[] methodArgs = method.getParameterTypes();
        if (methodArgs.length != classes.length) {
            return false;
        }
        for (int i = 0; i < classes.length; ++i) {
            if (MethodMap.isMethodInvocationConvertible(methodArgs[i], classes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isMethodInvocationConvertible(Class formal, Class actual) {
        if (actual == null && !formal.isPrimitive()) {
            return true;
        }
        if (actual != null && formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Boolean.TYPE && actual == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodMap.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return true;
            }
            if (formal == Character.TYPE && actual == (class$java$lang$Character == null ? (class$java$lang$Character = MethodMap.class$("java.lang.Character")) : class$java$lang$Character)) {
                return true;
            }
            if (formal == Byte.TYPE && actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return true;
            }
            if (formal == Short.TYPE && (actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Long.TYPE && (actual == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Float.TYPE && (actual == (class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float) || actual == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
            if (formal == Double.TYPE && (actual == (class$java$lang$Double == null ? (class$java$lang$Double = MethodMap.class$("java.lang.Double")) : class$java$lang$Double) || actual == (class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float) || actual == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isStrictMethodInvocationConvertible(Class formal, Class actual) {
        if (actual == null && !formal.isPrimitive()) {
            return true;
        }
        if (formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Short.TYPE && actual == Byte.TYPE) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Long.TYPE && (actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Float.TYPE && (actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Double.TYPE && (actual == Float.TYPE || actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class AmbiguousException
    extends Exception {
    }
}

