/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.util.introspection;

import java.lang.reflect.Method;
import org.apache.commons.jexl.util.introspection.IntrospectorBase;
import org.apache.commons.jexl.util.introspection.MethodMap;
import org.apache.commons.logging.Log;

public class Introspector
extends IntrospectorBase {
    public static final String CACHEDUMP_MSG = "Introspector : detected classloader change. Dumping cache.";
    private Log rlog = null;

    public Introspector(Log logger) {
        this.rlog = logger;
    }

    public Method getMethod(Class c, String name, Object[] params) throws Exception {
        try {
            return super.getMethod(c, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            String msg = "Introspection Error : Ambiguous method invocation " + name + "( ";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg = msg + ", ";
                }
                msg = msg + params[i].getClass().getName();
            }
            msg = msg + ") for class " + c;
            this.rlog.error((Object)msg);
            return null;
        }
    }

    protected void clearCache() {
        super.clearCache();
        this.rlog.info((Object)CACHEDUMP_MSG);
    }
}

