/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.jdk14;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;

public class DefaultConfigTestCase
extends TestCase {
    protected LogFactory factory = null;
    protected Log log = null;
    static /* synthetic */ Class class$junit$framework$Test;
    static /* synthetic */ Class class$org$apache$commons$logging$jdk14$DefaultConfigTestCase;

    public DefaultConfigTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.setUpFactory();
        this.setUpLog("TestLogger");
    }

    public static Test suite() throws Exception {
        PathableClassLoader loader = new PathableClassLoader(null);
        loader.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = DefaultConfigTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        loader.addLogicalLib("testclasses");
        loader.addLogicalLib("commons-logging");
        Class<?> testClass = loader.loadClass((class$org$apache$commons$logging$jdk14$DefaultConfigTestCase == null ? (class$org$apache$commons$logging$jdk14$DefaultConfigTestCase = DefaultConfigTestCase.class$("org.apache.commons.logging.jdk14.DefaultConfigTestCase")) : class$org$apache$commons$logging$jdk14$DefaultConfigTestCase).getName());
        return new PathableTestSuite(testClass, loader);
    }

    public void tearDown() {
        this.log = null;
        this.factory = null;
        LogFactory.releaseAll();
    }

    public void testPristineLog() {
        this.checkLog();
    }

    public void testPristineFactory() {
        DefaultConfigTestCase.assertNotNull((String)"LogFactory exists", (Object)this.factory);
        DefaultConfigTestCase.assertEquals((String)"LogFactory class", (String)"org.apache.commons.logging.impl.LogFactoryImpl", (String)this.factory.getClass().getName());
        String[] names = this.factory.getAttributeNames();
        DefaultConfigTestCase.assertNotNull((String)"Names exists", (Object)names);
        DefaultConfigTestCase.assertEquals((String)"Names empty", (int)0, (int)names.length);
    }

    public void testSerializable() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.log);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.log = (Log)ois.readObject();
        ois.close();
        this.checkLog();
    }

    protected void checkLog() {
        DefaultConfigTestCase.assertNotNull((String)"Log exists", (Object)this.log);
        DefaultConfigTestCase.assertEquals((String)"Log class", (String)"org.apache.commons.logging.impl.Jdk14Logger", (String)this.log.getClass().getName());
        this.log.isDebugEnabled();
        this.log.isErrorEnabled();
        this.log.isFatalEnabled();
        this.log.isInfoEnabled();
        this.log.isTraceEnabled();
        this.log.isWarnEnabled();
    }

    protected void setUpFactory() throws Exception {
        this.factory = LogFactory.getFactory();
    }

    protected void setUpLog(String name) throws Exception {
        this.log = LogFactory.getLog((String)name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

