/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.logkit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import org.apache.commons.logging.AbstractLogTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.impl.LogKitLogger;

public class StandardTestCase
extends AbstractLogTest {
    protected LogFactory factory = null;
    protected Log log = null;
    static /* synthetic */ Class class$org$apache$commons$logging$logkit$StandardTestCase;
    static /* synthetic */ Class class$junit$framework$Test;

    public static Test suite() throws Exception {
        Class thisClass = class$org$apache$commons$logging$logkit$StandardTestCase == null ? (class$org$apache$commons$logging$logkit$StandardTestCase = StandardTestCase.class$("org.apache.commons.logging.logkit.StandardTestCase")) : class$org$apache$commons$logging$logkit$StandardTestCase;
        PathableClassLoader loader = new PathableClassLoader(null);
        loader.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = StandardTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        loader.addLogicalLib("testclasses");
        loader.addLogicalLib("commons-logging");
        loader.addLogicalLib("logkit");
        Class<?> testClass = loader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, loader);
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.LogKitLogger");
        this.factory = LogFactory.getFactory();
        this.log = LogFactory.getLog((String)"TestLogger");
    }

    public void tearDown() {
        this.log = null;
        this.factory = null;
        LogFactory.releaseAll();
    }

    public Log getLogObject() {
        return new LogKitLogger(((Object)((Object)this)).getClass().getName());
    }

    public void testPristineFactory() {
        StandardTestCase.assertNotNull((String)"LogFactory exists", (Object)this.factory);
        StandardTestCase.assertEquals((String)"LogFactory class", (String)"org.apache.commons.logging.impl.LogFactoryImpl", (String)this.factory.getClass().getName());
        String[] names = this.factory.getAttributeNames();
        StandardTestCase.assertNotNull((String)"Names exists", (Object)names);
        StandardTestCase.assertEquals((String)"Names empty", (int)0, (int)names.length);
    }

    public void testPristineLog() {
        this.checkStandard();
    }

    public void testSerializable() throws Exception {
        this.checkStandard();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.log);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.log = (Log)ois.readObject();
        ois.close();
        this.checkStandard();
    }

    protected void checkStandard() {
        StandardTestCase.assertNotNull((String)"Log exists", (Object)this.log);
        StandardTestCase.assertEquals((String)"Log class", (String)"org.apache.commons.logging.impl.LogKitLogger", (String)this.log.getClass().getName());
        StandardTestCase.assertTrue((boolean)this.log.isTraceEnabled());
        StandardTestCase.assertTrue((boolean)this.log.isDebugEnabled());
        StandardTestCase.assertTrue((boolean)this.log.isInfoEnabled());
        StandardTestCase.assertTrue((boolean)this.log.isWarnEnabled());
        StandardTestCase.assertTrue((boolean)this.log.isErrorEnabled());
        StandardTestCase.assertTrue((boolean)this.log.isFatalEnabled());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

