/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.naming.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messenger.JNDISessionFactory;
import org.apache.commons.messenger.MessengerSession;
import org.apache.commons.messenger.MessengerSupport;
import org.apache.commons.messenger.SessionFactory;

public class DefaultMessenger
extends MessengerSupport {
    private static final boolean SHARE_CONNECTION = true;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messenger$DefaultMessenger == null ? (class$org$apache$commons$messenger$DefaultMessenger = DefaultMessenger.class$("org.apache.commons.messenger.DefaultMessenger")) : class$org$apache$commons$messenger$DefaultMessenger));
    private ThreadLocal messengerSessionPool = new ThreadLocal();
    private SessionFactory sessionFactory;
    static /* synthetic */ Class class$org$apache$commons$messenger$DefaultMessenger;

    public SessionFactory getSessionFactory() throws JMSException {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Connection getConnection() throws JMSException {
        return this.getSessionFactory().getConnection();
    }

    public ServerSessionPool createServerSessionPool(MessageListener messageListener, int maxThreads) throws JMSException {
        return this.getSessionFactory().createServerSessionPool(messageListener, maxThreads);
    }

    public void close() throws JMSException {
        try {
            this.getSessionFactory().close();
            Object var2_1 = null;
            this.messengerSessionPool = new ThreadLocal();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.messengerSessionPool = new ThreadLocal();
            throw throwable;
        }
    }

    public Session getSession() throws JMSException {
        return this.getMessengerSession().getSession();
    }

    protected boolean isTopic(Connection connection) throws JMSException {
        return this.getSessionFactory().isTopic();
    }

    protected boolean isTopic(ConnectionFactory factory) throws JMSException {
        return this.getSessionFactory().isTopic();
    }

    protected boolean isTopic(Session session) throws JMSException {
        return this.getSessionFactory().isTopic();
    }

    protected boolean isTopic(MessageProducer producer) throws JMSException {
        return this.getSessionFactory().isTopic();
    }

    protected Session borrowSession() throws JMSException {
        return this.getMessengerSession().getSession();
    }

    protected void returnSession(Session session) {
    }

    protected Session borrowListenerSession() throws JMSException {
        return this.getMessengerSession().getListenerSession();
    }

    protected void returnListenerSession(Session session) throws JMSException {
    }

    protected MessengerSession getMessengerSession() throws JMSException {
        MessengerSession answer = (MessengerSession)this.messengerSessionPool.get();
        if (answer == null) {
            answer = this.createMessengerSession();
            this.messengerSessionPool.set(answer);
        }
        return answer;
    }

    protected MessengerSession createMessengerSession() throws JMSException {
        return new MessengerSession(this, this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() throws JMSException {
        throw new JMSException("No SessionFactory configured for this Messenger. Cannot create a new JMS Session");
    }

    public Queue getQueue(QueueSession session, String subject) throws JMSException {
        Context ctx = null;
        JNDISessionFactory factory = null;
        Queue queue = null;
        if (this.isJndiDestinations()) {
            try {
                factory = (JNDISessionFactory)this.getSessionFactory();
                ctx = factory.getContext();
                queue = (Queue)ctx.lookup(subject);
            }
            catch (Exception e) {
                log.error((Object)("Unable to lookup subject: " + subject + ". Exception: " + e), (Throwable)e);
            }
        } else {
            queue = session.createQueue(subject);
        }
        return queue;
    }

    public Topic getTopic(TopicSession session, String subject) throws JMSException {
        Context ctx = null;
        JNDISessionFactory factory = null;
        Topic topic = null;
        if (this.isJndiDestinations()) {
            try {
                factory = (JNDISessionFactory)this.getSessionFactory();
                ctx = factory.getContext();
                topic = (Topic)ctx.lookup(subject);
            }
            catch (Exception e) {
                log.error((Object)("Unable to lookup subject: " + subject + ". Exception: " + e), (Throwable)e);
            }
        } else {
            topic = session.createTopic(subject);
        }
        return topic;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

