/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.QueueBrowser;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.messenger.SessionFactory;

public interface Messenger {
    public String getName();

    public Destination getDestination(String var1) throws JMSException;

    public Destination createTemporaryDestination() throws JMSException;

    public void send(Destination var1, Message var2) throws JMSException;

    public Message call(Destination var1, Message var2) throws JMSException;

    public Message call(Destination var1, Message var2, long var3) throws JMSException;

    public Message receive(Destination var1) throws JMSException;

    public Message receive(Destination var1, String var2) throws JMSException;

    public Message receive(Destination var1, long var2) throws JMSException;

    public Message receive(Destination var1, String var2, long var3) throws JMSException;

    public Message receiveNoWait(Destination var1) throws JMSException;

    public Message receiveNoWait(Destination var1, String var2) throws JMSException;

    public MessageConsumer createConsumer(Destination var1) throws JMSException;

    public MessageConsumer createConsumer(Destination var1, String var2) throws JMSException;

    public QueueBrowser createBrowser(Destination var1) throws JMSException;

    public void run();

    public Connection getConnection() throws JMSException;

    public Session getSession() throws JMSException;

    public ConnectionConsumer createConnectionConsumer(Destination var1, ServerSessionPool var2, int var3) throws JMSException;

    public ConnectionConsumer createConnectionConsumer(Destination var1, String var2, ServerSessionPool var3, int var4) throws JMSException;

    public ServerSessionPool createServerSessionPool(MessageListener var1, int var2) throws JMSException;

    public void addListener(Destination var1, MessageListener var2) throws JMSException;

    public void addListener(Destination var1, String var2, MessageListener var3) throws JMSException;

    public void removeListener(Destination var1, MessageListener var2) throws JMSException;

    public void removeListener(Destination var1, String var2, MessageListener var3) throws JMSException;

    public BytesMessage createBytesMessage() throws JMSException;

    public MapMessage createMapMessage() throws JMSException;

    public Message createMessage() throws JMSException;

    public ObjectMessage createObjectMessage() throws JMSException;

    public ObjectMessage createObjectMessage(Serializable var1) throws JMSException;

    public StreamMessage createStreamMessage() throws JMSException;

    public TextMessage createTextMessage() throws JMSException;

    public TextMessage createTextMessage(String var1) throws JMSException;

    public void commit() throws JMSException;

    public void rollback() throws JMSException;

    public void close() throws JMSException;

    public SessionFactory getSessionFactory() throws JMSException;

    public int getDeliveryMode(Destination var1) throws JMSException;

    public boolean getDisableMessageID(Destination var1) throws JMSException;

    public boolean getDisableMessageTimestamp(Destination var1) throws JMSException;

    public int getPriority(Destination var1) throws JMSException;

    public long getTimeToLive(Destination var1) throws JMSException;

    public void setDeliveryMode(Destination var1, int var2) throws JMSException;

    public void setDisableMessageID(Destination var1, boolean var2) throws JMSException;

    public void setDisableMessageTimestamp(Destination var1, boolean var2) throws JMSException;

    public void setPriority(Destination var1, int var2) throws JMSException;

    public void setTimeToLive(Destination var1, long var2) throws JMSException;
}

