/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import javax.jms.Session;
import javax.jms.XASession;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.XACapable;

public class XACapableAdapter
implements XACapable {
    private Messenger messenger;

    public XACapableAdapter(Messenger messenger) {
        this.messenger = messenger;
    }

    public void enlistResources(Transaction transaction) throws Exception {
        XAResource resource = this.getXAResource();
        if (resource != null) {
            transaction.enlistResource(resource);
        }
    }

    public void delistResources(Transaction transaction, int flag) throws Exception {
        XAResource resource = this.getXAResource();
        if (resource != null) {
            transaction.delistResource(resource, flag);
        }
    }

    protected XAResource getXAResource() throws Exception {
        Session session = this.messenger.getSession();
        if (session instanceof XASession) {
            XASession xaSession = (XASession)session;
            return xaSession.getXAResource();
        }
        return null;
    }
}

