/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet;

import java.net.URL;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.messagelet.SubscriptionManager;
import org.apache.commons.messagelet.model.SubscriptionDigester;
import org.apache.commons.messagelet.model.SubscriptionList;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;

public class ManagerServlet
extends GenericServlet {
    private static final boolean USE_HTTP_SERVLETS = true;
    private static final String KEY_CONNECTIONS = "connections";
    private static final String KEY_SUBSCRIPTIONS = "subscriptions";
    private boolean continueOnSubscribeException;

    public SubscriptionManager getSubscriptionManager() {
        SubscriptionManager answer = (SubscriptionManager)this.getServletContext().getAttribute("subscriptionManager");
        if (answer == null) {
            answer = new SubscriptionManager();
            this.getServletContext().setAttribute("subscriptionManager", (Object)answer);
        }
        return answer;
    }

    public synchronized void init() throws ServletException {
        String text = this.getServletContext().getInitParameter("continueOnSubscribeException");
        if (text != null && text.equals("true")) {
            this.continueOnSubscribeException = true;
        }
        try {
            SubscriptionManager subscriber = this.getSubscriptionManager();
            MessengerManager manager = subscriber.getMessengerManager();
            if (manager == null) {
                manager = this.createMessengerManager();
                subscriber.setMessengerManager(manager);
                subscriber.setSubscriptionList(this.createSubscriptionList());
                subscriber.setServletContext(this.getServletContext());
                subscriber.subscribe();
                Iterator iter = manager.getMessengerNames();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    Messenger messenger = manager.getMessenger(name);
                    try {
                        messenger.getConnection().start();
                    }
                    catch (JMSException e) {
                        this.log("Caught exception trying to start messenger: " + name + ". Exception: " + (Object)((Object)e), e);
                    }
                }
            }
        }
        catch (JMSException e) {
            throw new ServletException("Failed to initialize: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void destroy() {
        try {
            this.getSubscriptionManager().unsubscribe();
        }
        catch (Exception e) {
            this.log("Failed to destrory the MBOs: " + e, e);
        }
        try {
            MessengerManager manager = this.getSubscriptionManager().getMessengerManager();
            if (manager != null) {
                this.log("Closing the Messenger connections");
                manager.close();
            }
        }
        catch (Exception e) {
            this.log("Failed to close the Messenger Manager: " + e, e);
        }
        this.getSubscriptionManager().setMessengerManager(null);
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException {
    }

    public boolean isContinueOnSubscriptionException() {
        return this.continueOnSubscribeException;
    }

    public void setContinueOnSubscribeException(boolean continueOnSubscribeException) {
        this.continueOnSubscribeException = continueOnSubscribeException;
    }

    protected MessengerManager createMessengerManager() throws ServletException {
        String config = this.getURLResource(KEY_CONNECTIONS, "The Messenger connections XML deployment document");
        this.log("Creating the Messenger connections from the file: " + config);
        try {
            return MessengerManager.load(config);
        }
        catch (JMSException e) {
            this.log("Could not parse Messenger connection XML deployment document for URL: " + config, e);
            throw new ServletException("Could not parse Messenger connection XML deployment document for URL: " + config + " reason: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected SubscriptionList createSubscriptionList() throws ServletException {
        String config = this.getURLResource(KEY_SUBSCRIPTIONS, "The Messenger subscriptions XML deployment document");
        this.log("Loading the Messenger subscriptions from: " + config);
        try {
            SubscriptionDigester digester = new SubscriptionDigester();
            return (SubscriptionList)digester.parse(config);
        }
        catch (Exception e) {
            this.log("Could not parse Messenger subscription XML deployment document for URL: " + config, e);
            throw new ServletException("Could not parse Messenger subscription XML deployment document for URL: " + config + " reason: " + e, (Throwable)e);
        }
    }

    protected String getURLResource(String key, String description) throws ServletException {
        String config = this.getInitParameter(key);
        if (config == null || config.length() == 0) {
            throw new ServletException("No initialization parameter for parameter: " + key + " description: " + description);
        }
        try {
            URL url = this.getServletContext().getResource(config);
            config = url.toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        return config;
    }

    protected void handleJMSException(String message, JMSException exception) throws ServletException {
        this.log(message, exception);
        if (!this.isContinueOnSubscriptionException()) {
            throw new ServletException(message, (Throwable)exception);
        }
    }
}

