/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet;

import java.net.URL;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.messagelet.MessageDrivenObject;
import org.apache.commons.messagelet.MessengerMDO;
import org.apache.commons.messagelet.impl.MessageHttpServletDispatcher;
import org.apache.commons.messagelet.impl.Subscription;
import org.apache.commons.messagelet.impl.SubscriptionDigester;
import org.apache.commons.messagelet.impl.SubscriptionList;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;

public class ManagerServlet
extends GenericServlet {
    private static final String KEY_MESSENGER_MANAGER = (class$org$apache$commons$messenger$MessengerManager == null ? (class$org$apache$commons$messenger$MessengerManager = ManagerServlet.class$("org.apache.commons.messenger.MessengerManager")) : class$org$apache$commons$messenger$MessengerManager).getName();
    private static final String KEY_SUBSCRIPTIONLIST = (class$org$apache$commons$messagelet$impl$SubscriptionList == null ? (class$org$apache$commons$messagelet$impl$SubscriptionList = ManagerServlet.class$("org.apache.commons.messagelet.impl.SubscriptionList")) : class$org$apache$commons$messagelet$impl$SubscriptionList).getName();
    private static final String KEY_CONNECTIONS = "connections";
    private static final String KEY_SUBSCRIPTIONS = "subscriptions";
    private static final boolean USE_HTTP_SERVLETS = true;
    static /* synthetic */ Class class$org$apache$commons$messenger$MessengerManager;
    static /* synthetic */ Class class$org$apache$commons$messagelet$impl$SubscriptionList;

    public MessengerManager getMessengerManager() {
        return (MessengerManager)this.getServletContext().getAttribute(KEY_MESSENGER_MANAGER);
    }

    public void setMessengerManager(MessengerManager messengerManager) {
        if (messengerManager == null) {
            this.getServletContext().removeAttribute(KEY_MESSENGER_MANAGER);
        } else {
            this.getServletContext().setAttribute(KEY_MESSENGER_MANAGER, (Object)messengerManager);
        }
    }

    public SubscriptionList getSubscriptionList() {
        return (SubscriptionList)this.getServletContext().getAttribute(KEY_SUBSCRIPTIONLIST);
    }

    public void setSubscriptionList(SubscriptionList subscriptionList) {
        if (subscriptionList == null) {
            this.getServletContext().removeAttribute(KEY_SUBSCRIPTIONLIST);
        } else {
            this.getServletContext().setAttribute(KEY_SUBSCRIPTIONLIST, (Object)subscriptionList);
        }
    }

    public Messenger getMessenger(String name) throws ServletException {
        MessengerManager messengerManager = this.getMessengerManager();
        if (messengerManager == null) {
            throw new ServletException("No MessengerManager has been initialized yet");
        }
        return messengerManager.getMessenger(name);
    }

    public synchronized void init() throws ServletException {
        MessengerManager manager = this.getMessengerManager();
        if (manager == null) {
            manager = this.createMessengerManager();
            this.setMessengerManager(manager);
            SubscriptionList list = this.createSubscriptionList();
            this.subscribe(list);
            this.setSubscriptionList(list);
            Iterator iter = manager.getMessengerNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Messenger messenger = manager.getMessenger(name);
                try {
                    messenger.getConnection().start();
                }
                catch (JMSException e) {
                    this.log("Caught exception trying to start messenger: " + name + ". Exception: " + (Object)((Object)e), e);
                }
            }
        }
    }

    public void destroy() {
        try {
            this.destroyMBOs();
        }
        catch (ServletException e) {
            this.log("Failed to destrory the MBOs: " + (Object)((Object)e), e);
        }
        MessengerManager manager = this.getMessengerManager();
        if (manager != null) {
            this.log("Closing the Messenger connections");
            manager.close();
        }
        this.setMessengerManager(null);
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException {
    }

    protected void subscribe(SubscriptionList list) throws ServletException {
        Iterator iter = list.getSubscriptions().iterator();
        while (iter.hasNext()) {
            Subscription subscription = (Subscription)iter.next();
            this.subscribe(subscription);
        }
    }

    protected void subscribe(Subscription subscription) throws ServletException {
        String subject;
        String name = subscription.getConnection();
        Messenger messenger = this.getMessenger(name);
        if (messenger == null) {
            throw new ServletException("No such Messenger called: " + name + " for subscription: " + subscription);
        }
        MessageListener listener = null;
        String servlet = subscription.getServlet();
        if (servlet != null) {
            listener = new MessageHttpServletDispatcher(servlet);
        } else {
            listener = subscription.getMessageListener();
            if (listener == null) {
                throw new ServletException("No MessageListener is defined for subscription: " + subscription);
            }
        }
        if (listener instanceof MessageDrivenObject) {
            MessageDrivenObject mdo = (MessageDrivenObject)listener;
            if (mdo instanceof MessengerMDO) {
                MessengerMDO messengerMDO = (MessengerMDO)mdo;
                messengerMDO.setMessenger(messenger);
                messengerMDO.setMessengerManager(this.getMessengerManager());
            }
            mdo.init(this.getServletContext());
        }
        if ((subject = subscription.getSubject()) == null || subject.length() == 0) {
            throw new ServletException("No destination defined for subscription: " + subscription);
        }
        Destination destination = null;
        try {
            destination = messenger.getDestination(subject);
        }
        catch (JMSException e) {
            throw new ServletException("Could not create destination for name: " + subject + " for subscription: " + subscription, (Throwable)e);
        }
        if (destination == null) {
            throw new ServletException("No destination could be found for name: " + subject + " for subscription: " + subscription);
        }
        try {
            String selector = subscription.getSelector();
            if (selector != null && selector.length() > 0) {
                this.log("Subscribing to messenger: " + name + " destination: " + subject + " selector: " + selector);
                messenger.addListener(destination, selector, listener);
            } else {
                this.log("Subscribing to messenger: " + name + " destination: " + subject);
                messenger.addListener(destination, listener);
            }
        }
        catch (JMSException e) {
            throw new ServletException("Could not subscribe to destination:" + destination + " for subscription: " + subscription, (Throwable)e);
        }
    }

    protected void destroyMBOs() throws ServletException {
        SubscriptionList list = this.getSubscriptionList();
        if (list != null) {
            Iterator iter = list.getSubscriptions().iterator();
            while (iter.hasNext()) {
                Subscription subscription = (Subscription)iter.next();
                this.destroyMBOs(subscription);
            }
        }
    }

    protected void destroyMBOs(Subscription subscription) throws ServletException {
        String name = subscription.getConnection();
        Messenger messenger = this.getMessenger(name);
        MessageListener listener = subscription.getMessageListener();
        if (messenger != null && listener != null) {
            Destination destination = null;
            String subject = subscription.getSubject();
            if (subject == null || subject.length() == 0) {
                this.log("No destination defined for subscription: " + subscription);
            } else {
                try {
                    destination = messenger.getDestination(subject);
                    if (destination == null) {
                        this.log("No destination could be found for name: " + subject + " for subscription: " + subscription);
                    }
                }
                catch (JMSException e) {
                    this.log("Could not create destination for name: " + subject + " for subscription: " + subscription, e);
                }
            }
            if (destination != null) {
                try {
                    String selector = subscription.getSelector();
                    if (selector != null && selector.length() > 0) {
                        messenger.removeListener(destination, selector, listener);
                    } else {
                        messenger.removeListener(destination, listener);
                    }
                }
                catch (JMSException e) {
                    this.log("Could not unsubscribe to destination:" + destination + " for subscription: " + subscription, e);
                }
            }
        }
        if (listener instanceof MessageDrivenObject) {
            MessageDrivenObject mdo = (MessageDrivenObject)listener;
            mdo.destroy();
        }
    }

    protected MessengerManager createMessengerManager() throws ServletException {
        String config = this.getURLResource(KEY_CONNECTIONS, "The Messenger connections XML deployment document");
        this.log("Creating the Messenger connections from the file: " + config);
        try {
            return MessengerManager.load(config);
        }
        catch (JMSException e) {
            this.log("Could not parse Messenger connection XML deployment document for URL: " + config, e);
            throw new ServletException("Could not parse Messenger connection XML deployment document for URL: " + config + " reason: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected SubscriptionList createSubscriptionList() throws ServletException {
        String config = this.getURLResource(KEY_SUBSCRIPTIONS, "The Messenger subscriptions XML deployment document");
        this.log("Loading the Messenger subscriptions from: " + config);
        try {
            SubscriptionDigester digester = new SubscriptionDigester();
            return (SubscriptionList)digester.parse(config);
        }
        catch (Exception e) {
            this.log("Could not parse Messenger subscription XML deployment document for URL: " + config, e);
            throw new ServletException("Could not parse Messenger subscription XML deployment document for URL: " + config + " reason: " + e, (Throwable)e);
        }
    }

    protected String getURLResource(String key, String description) throws ServletException {
        String config = this.getInitParameter(key);
        if (config == null || config.length() == 0) {
            throw new ServletException("No initialization parameter for parameter: " + key + " description: " + description);
        }
        try {
            URL url = this.getServletContext().getResource(config);
            config = url.toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        return config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

