/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import org.apache.commons.messagelet.impl.BufferedServletOutputStream;

public class ServletResponseImpl
implements ServletResponse {
    protected byte[] buffer = new byte[1024];
    protected int bufferCount = 0;
    protected boolean committed = false;
    protected int contentCount = 0;
    protected int contentLength = -1;
    protected String contentType = null;
    protected String encoding = null;
    protected boolean included = false;
    protected Locale locale = Locale.getDefault();
    protected OutputStream output = null;
    protected ServletOutputStream stream = null;
    protected PrintWriter writer = null;
    protected boolean error = false;

    public int getContentCount() {
        return this.contentCount;
    }

    public OutputStream getStream() {
        return this.output;
    }

    public void setStream(OutputStream stream) {
        this.output = stream;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new BufferedServletOutputStream();
    }

    public void finishResponse() throws IOException {
        if (this.stream == null) {
            ServletOutputStream sos = this.getOutputStream();
            sos.flush();
            sos.close();
            return;
        }
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        } else {
            this.stream.flush();
            this.stream.close();
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void flushBuffer() throws IOException {
        this.committed = true;
        if (this.bufferCount > 0) {
            try {
                this.output.write(this.buffer, 0, this.bufferCount);
                Object var2_1 = null;
                this.bufferCount = 0;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.bufferCount = 0;
                throw throwable;
            }
        }
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public String getCharacterEncoding() {
        if (this.encoding == null) {
            return "ISO-8859-1";
        }
        return this.encoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, this.getCharacterEncoding()));
        return this.writer;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException("response has already been committed");
        }
        if (this.included) {
            return;
        }
        this.bufferCount = 0;
        this.contentLength = -1;
        this.contentType = null;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("response has already been committed");
        }
        this.bufferCount = 0;
    }

    public void setBufferSize(int size) {
        if (this.committed || this.bufferCount > 0) {
            throw new IllegalStateException("Output has already been committed");
        }
        if (this.buffer.length >= size) {
            return;
        }
        this.buffer = new byte[size];
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.contentLength = length;
    }

    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.contentType = type;
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.locale = locale;
    }
}

