/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import org.apache.commons.messagelet.MessageletResponse;
import org.apache.commons.messagelet.impl.BufferedServletOutputStream;
import org.apache.commons.messenger.Messenger;

public class MessageletResponseImpl
extends ServletResponseWrapper
implements MessageletResponse {
    private Messenger messenger;
    private Destination replyToDestination;
    private BufferedServletOutputStream stream = null;
    protected PrintWriter writer;

    public MessageletResponseImpl(ServletResponse response) {
        super(response);
    }

    public void reset() {
        this.writer = null;
        this.stream = null;
    }

    public void finish() throws IOException, JMSException {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
            if (this.stream != null) {
                byte[] data = this.stream.toByteArray();
                String text = new String(data);
                TextMessage message = this.getReplyMessenger().createTextMessage(text);
                this.sendReply((Message)message);
            }
            Object var5_4 = null;
            this.writer = null;
            this.stream = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writer = null;
            this.stream = null;
            throw throwable;
        }
    }

    public void sendReply(Message replyMessage) throws JMSException {
        this.getReplyMessenger().send(this.getReplyToDestination(), replyMessage);
    }

    public Messenger getReplyMessenger() {
        return this.messenger;
    }

    public Destination getReplyToDestination() {
        return this.replyToDestination;
    }

    public void setReplyMessenger(Messenger messenger) {
        this.messenger = messenger;
    }

    public void setReplyToDestination(Destination replyToDestination) {
        this.replyToDestination = replyToDestination;
    }

    public void flushBuffer() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter((OutputStream)((Object)this.stream));
        return this.writer;
    }

    protected BufferedServletOutputStream createOutputStream() {
        return new BufferedServletOutputStream();
    }
}

