/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicRequestor;
import javax.jms.TopicSession;
import org.apache.commons.messenger.MessengerSupport;
import org.apache.commons.messenger.SessionFactory;

public class MessengerSession {
    private Session session;
    private Session listenerSession;
    private SessionFactory sessionFactory;
    private Map requestorsMap;
    private Destination replyToDestination;
    private MessengerSupport messenger;

    public MessengerSession(MessengerSupport messenger, SessionFactory sessionFactory) {
        this.messenger = messenger;
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Session getSession() throws JMSException {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public Session getListenerSession() throws JMSException {
        if (this.listenerSession == null) {
            this.listenerSession = this.createSession();
        }
        return this.listenerSession;
    }

    protected Destination getReplyToDestination() throws JMSException {
        if (this.replyToDestination == null) {
            this.replyToDestination = this.createTemporaryDestination();
        }
        return this.replyToDestination;
    }

    public TopicRequestor getTopicRequestor(TopicSession session, Topic destination) throws JMSException {
        if (this.messenger.isCacheRequestors()) {
            TopicRequestor requestor = (TopicRequestor)this.getRequestorsMap().get(destination);
            if (requestor == null) {
                requestor = new TopicRequestor(session, destination);
                this.getRequestorsMap().put(destination, requestor);
            }
            return requestor;
        }
        return new TopicRequestor(session, destination);
    }

    public QueueRequestor getQueueRequestor(QueueSession session, Queue destination) throws JMSException {
        if (this.messenger.isCacheRequestors()) {
            QueueRequestor requestor = (QueueRequestor)this.getRequestorsMap().get(destination);
            if (requestor == null) {
                requestor = new QueueRequestor(session, destination);
                this.getRequestorsMap().put(destination, requestor);
            }
            return requestor;
        }
        return new QueueRequestor(session, destination);
    }

    protected Session createSession() throws JMSException {
        return this.getSessionFactory().createSession(this.messenger.getConnection());
    }

    protected Destination createTemporaryDestination() throws JMSException {
        if (this.messenger.isTopic(this.session)) {
            TopicSession topicSession = (TopicSession)this.session;
            return topicSession.createTemporaryTopic();
        }
        QueueSession queueSession = (QueueSession)this.session;
        return queueSession.createTemporaryQueue();
    }

    protected Map getRequestorsMap() {
        if (this.requestorsMap == null) {
            this.requestorsMap = new HashMap();
        }
        return this.requestorsMap;
    }
}

