/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messagelet.MessengerMDO;
import org.apache.commons.messenger.Messenger;

public class BridgeMDO
extends MessengerMDO {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messagelet$BridgeMDO == null ? (class$org$apache$commons$messagelet$BridgeMDO = BridgeMDO.class$("org.apache.commons.messagelet.BridgeMDO")) : class$org$apache$commons$messagelet$BridgeMDO));
    private Messenger outputMessenger;
    private Destination outputDestination;
    private String outputConnection;
    private String outputSubject;
    private int bufferSize = 32768;
    static /* synthetic */ Class class$org$apache$commons$messagelet$BridgeMDO;

    public void init() throws ServletException {
        try {
            Messenger messenger = this.getMessenger();
            Messenger outputMessenger = this.getOutputMessenger();
            if (messenger == null) {
                throw new ServletException("No input Messenger is defined for this Bridge");
            }
            if (outputMessenger == null) {
                throw new ServletException("No output Messenger is defined for this Bridge");
            }
            this.validateOutputDestination();
            messenger.getSessionFactory().setTransacted(true);
            outputMessenger.getSessionFactory().setTransacted(true);
            messenger.getSessionFactory().setAcknowledgeMode(2);
            outputMessenger.getSessionFactory().setAcknowledgeMode(2);
        }
        catch (JMSException e) {
            log.error((Object)"Caught exception trying to configure the transacted, client acknowledge modes of the JMS connections");
            log.error((Object)("Caught: " + (Object)((Object)e)), (Throwable)e);
            throw new ServletException("Caught exception trying to configure the transacted, client acknowledge modes of the JMS connections" + (Object)((Object)e), (Throwable)e);
        }
    }

    public void onMessage(Message message) {
        Messenger messenger = this.getMessenger();
        try {
            Message outputMessage = this.createOutputMessage(message);
            if (outputMessage != null) {
                Destination destination = this.getOutputDestination();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending message to: " + destination));
                }
                this.getOutputMessenger().send(destination, outputMessage);
            }
            this.acknowledge(message);
            this.acknowledge(outputMessage);
            this.commit();
        }
        catch (Exception e) {
            log.error((Object)"Could not send message due to exception", (Throwable)e);
            this.rollback();
        }
    }

    public String getOutputConnection() {
        return this.outputConnection;
    }

    public void setOutputConnection(String outputConnection) {
        this.outputConnection = outputConnection;
    }

    public String getOutputSubject() {
        return this.outputSubject;
    }

    public void setOutputSubject(String outputSubject) {
        this.outputSubject = outputSubject;
    }

    public Messenger getOutputMessenger() throws JMSException {
        if (this.outputMessenger == null) {
            String name = this.getOutputConnection();
            this.outputMessenger = name != null ? this.getMessengerManager().getMessenger(name) : this.getMessenger();
        }
        return this.outputMessenger;
    }

    public void setOutputMessenger(Messenger outputMessenger) {
        this.outputMessenger = outputMessenger;
    }

    public Destination getOutputDestination() throws JMSException {
        if (this.outputDestination == null) {
            String subject = this.getOutputSubject();
            if (subject == null) {
                throw new JMSException("A bridge must have an outputSubject defined!");
            }
            this.outputDestination = this.getOutputMessenger().getDestination(subject);
        }
        return this.outputDestination;
    }

    public void setOutputDestination(Destination outputDestination) {
        this.outputDestination = outputDestination;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected void commit() throws JMSException {
        this.getOutputMessenger().commit();
        this.getMessenger().commit();
    }

    protected void rollback() {
        try {
            this.getOutputMessenger().rollback();
        }
        catch (Exception e) {
            log.error((Object)("Caught exception rolling back the output messenger: " + e), (Throwable)e);
        }
        try {
            this.getMessenger().rollback();
        }
        catch (Exception e) {
            log.error((Object)("Caught exception rolling back the input messenger: " + e), (Throwable)e);
        }
    }

    protected Message createOutputMessage(Message inputMessage) throws JMSException {
        Object outputMessage = null;
        outputMessage = inputMessage instanceof TextMessage ? this.createOutputTextMessage((TextMessage)inputMessage) : (inputMessage instanceof ObjectMessage ? this.createOutputObjectMessage((ObjectMessage)inputMessage) : (inputMessage instanceof MapMessage ? this.createOutputMapMessage((MapMessage)inputMessage) : (inputMessage instanceof BytesMessage ? this.createOutputBytesMessage((BytesMessage)inputMessage) : (inputMessage instanceof StreamMessage ? this.createOutputStreamMessage((StreamMessage)inputMessage) : this.getOutputMessenger().createMessage()))));
        this.processMessageHeaders(inputMessage, (Message)outputMessage);
        return outputMessage;
    }

    protected ObjectMessage createOutputObjectMessage(ObjectMessage inputMessage) throws JMSException {
        return this.getOutputMessenger().createObjectMessage(inputMessage.getObject());
    }

    protected TextMessage createOutputTextMessage(TextMessage inputMessage) throws JMSException {
        return this.getOutputMessenger().createTextMessage(inputMessage.getText());
    }

    protected MapMessage createOutputMapMessage(MapMessage inputMessage) throws JMSException {
        MapMessage answer = this.getOutputMessenger().createMapMessage();
        Enumeration enumeration = inputMessage.getMapNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Object value = inputMessage.getObject(name);
            answer.setObject(name, value);
        }
        return answer;
    }

    protected BytesMessage createOutputBytesMessage(BytesMessage inputMessage) throws JMSException {
        int size;
        BytesMessage answer = this.getOutputMessenger().createBytesMessage();
        byte[] buffer = new byte[this.bufferSize];
        while ((size = inputMessage.readBytes(buffer)) > 0) {
            answer.writeBytes(buffer, 0, size);
            if (size >= this.bufferSize) continue;
            break;
        }
        return answer;
    }

    protected StreamMessage createOutputStreamMessage(StreamMessage inputMessage) throws JMSException {
        int size;
        StreamMessage answer = this.getOutputMessenger().createStreamMessage();
        byte[] buffer = new byte[this.bufferSize];
        while ((size = inputMessage.readBytes(buffer)) > 0) {
            answer.writeBytes(buffer, 0, size);
            if (size >= this.bufferSize) continue;
            break;
        }
        return answer;
    }

    protected void processMessageHeaders(Message inputMessage, Message outputMessage) throws JMSException {
    }

    protected void acknowledge(Message message) throws JMSException {
        message.acknowledge();
    }

    protected void validateOutputDestination() throws JMSException, ServletException {
        if (this.getOutputDestination() == null) {
            throw new ServletException("No output Destination is defined for this Bridge");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

