/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet;

import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messagelet.MessageDrivenObject;
import org.apache.commons.messagelet.MessengerMDO;
import org.apache.commons.messagelet.impl.Subscription;
import org.apache.commons.messagelet.impl.SubscriptionDigester;
import org.apache.commons.messagelet.impl.SubscriptionList;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;

public class Main {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messagelet$DistributeBridgeMDO == null ? (class$org$apache$commons$messagelet$DistributeBridgeMDO = Main.class$("org.apache.commons.messagelet.DistributeBridgeMDO")) : class$org$apache$commons$messagelet$DistributeBridgeMDO));
    private MessengerManager manager;
    private SubscriptionList subscriptionList;
    private String connectionsConfig = "Messenger.xml";
    private String subscriptionsConfig = "subscriptions.xml";
    static /* synthetic */ Class class$org$apache$commons$messagelet$DistributeBridgeMDO;

    public static void main(String[] args) {
        Main main = new Main();
        if (args.length <= 0) {
            System.out.println("Usage <subscriptionConfigFile> [<connectionsConfigFile>]");
            return;
        }
        if (args.length > 0) {
            main.setSubscriptionsConfig(args[0]);
        }
        if (args.length > 1) {
            main.setConnectionsConfig(args[1]);
        }
        try {
            main.run();
        }
        catch (Exception e) {
            log.error((Object)("Caught: " + e), (Throwable)e);
        }
    }

    public void run() throws Exception {
        this.getMessengerManager();
        this.subscriptionList = this.createSubscriptionList();
        this.subscribe(this.subscriptionList);
        Iterator iter = this.manager.getMessengerNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Messenger messenger = this.manager.getMessenger(name);
            try {
                messenger.getConnection().start();
            }
            catch (JMSException e) {
                log.error((Object)("Caught exception trying to start messenger: " + name + ". Exception: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public Messenger getMessenger(String name) throws JMSException {
        return this.getMessengerManager().getMessenger(name);
    }

    public String getConnectionsConfig() {
        return this.connectionsConfig;
    }

    public void setConnectionsConfig(String connectionsConfig) {
        this.connectionsConfig = connectionsConfig;
    }

    public String getSubscriptionsConfig() {
        return this.subscriptionsConfig;
    }

    public void setSubscriptionsConfig(String subscriptionsConfig) {
        this.subscriptionsConfig = subscriptionsConfig;
    }

    public MessengerManager getMessengerManager() throws JMSException {
        if (this.manager == null) {
            this.manager = this.createMessengerManager();
            MessengerManager.setInstance(this.manager);
        }
        return this.manager;
    }

    public void setMessengerManager(MessengerManager manager) {
        this.manager = manager;
    }

    protected void subscribe(SubscriptionList list) throws JMSException, ServletException {
        Iterator iter = list.getSubscriptions().iterator();
        while (iter.hasNext()) {
            Subscription subscription = (Subscription)iter.next();
            this.subscribe(subscription);
        }
    }

    protected void subscribe(Subscription subscription) throws JMSException, ServletException {
        String subject;
        String name = subscription.getConnection();
        Messenger messenger = this.getMessenger(name);
        if (messenger == null) {
            throw new JMSException("No such Messenger called: " + name + " for subscription: " + subscription);
        }
        MessageListener listener = subscription.getMessageListener();
        if (listener == null) {
            throw new JMSException("No MessageListener is defined for subscription: " + subscription);
        }
        if (listener instanceof MessageDrivenObject) {
            MessageDrivenObject mdo = (MessageDrivenObject)listener;
            if (mdo instanceof MessengerMDO) {
                MessengerMDO messengerMDO = (MessengerMDO)mdo;
                messengerMDO.setMessenger(messenger);
                messengerMDO.setMessengerManager(this.getMessengerManager());
            }
            mdo.init(this.getServletContext());
        }
        if ((subject = subscription.getSubject()) == null || subject.length() == 0) {
            throw new JMSException("No destination defined for subscription: " + subscription);
        }
        Destination destination = messenger.getDestination(subject);
        if (destination == null) {
            throw new JMSException("No destination could be found for name: " + subject + " for subscription: " + subscription);
        }
        String selector = subscription.getSelector();
        if (selector != null && selector.length() > 0) {
            log.info((Object)("Subscribing to messenger: " + name + " destination: " + subject + " selector: " + selector));
            messenger.addListener(destination, selector, listener);
        } else {
            log.info((Object)("Subscribing to messenger: " + name + " destination: " + subject));
            messenger.addListener(destination, listener);
        }
    }

    protected MessengerManager createMessengerManager() throws JMSException {
        String config = this.connectionsConfig;
        log.info((Object)("Creating the JMS connections from the file: " + config));
        try {
            return MessengerManager.load(config);
        }
        catch (JMSException e) {
            log.error((Object)("Could not parse Messenger connection XML deployment document for URL: " + config), (Throwable)e);
            throw new JMSException("Could not parse Messenger connection XML deployment document for URL: " + config + " reason: " + (Object)((Object)e));
        }
    }

    protected SubscriptionList createSubscriptionList() throws JMSException {
        String config = this.subscriptionsConfig;
        log.info((Object)("Loading the JMS subscriptions from: " + config));
        try {
            SubscriptionDigester digester = new SubscriptionDigester();
            return (SubscriptionList)digester.parse(config);
        }
        catch (Exception e) {
            log.error((Object)("Could not parse Messenger subscription XML deployment document for URL: " + config), (Throwable)e);
            throw new JMSException("Could not parse Messenger subscription XML deployment document for URL: " + config + " reason: " + e);
        }
    }

    protected ServletContext getServletContext() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

