/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import org.apache.commons.messagelet.MessageletRequest;
import org.apache.commons.messagelet.impl.BufferedServletInputStream;
import org.apache.commons.messenger.Messenger;

public class MessageletRequestImpl
extends ServletRequestWrapper
implements MessageletRequest {
    private Message message;
    private ServletInputStream stream;

    public MessageletRequestImpl(ServletRequest request) {
        super(request);
    }

    public void setMessage(Message message) throws JMSException {
        this.message = message;
        this.stream = this.createInputStream();
        this.setAttribute("message", message);
    }

    public void setMessenger(Messenger messenger) {
        this.setAttribute("messenger", messenger);
    }

    public Message getMessage() {
        return this.message;
    }

    public ServletInputStream getInputStream() {
        return this.stream;
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.stream));
    }

    protected ServletInputStream createInputStream() throws JMSException {
        if (this.message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)this.message;
            return new BufferedServletInputStream(textMessage.getText());
        }
        return new BufferedServletInputStream();
    }
}

