/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.commons.messenger.ListenerKey;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerListener;
import org.apache.commons.messenger.MessengerSession;
import org.apache.commons.messenger.SessionFactory;

public abstract class MessengerSupport
implements Messenger {
    private static final boolean CACHE_REQUESTOR = true;
    private String name;
    private boolean jndiDestinations;
    private boolean durable;
    private String durableName;
    private boolean noLocal;
    private boolean cacheRequestors;
    private Map listeners = new HashMap();
    private boolean cacheProducers = true;

    public String toString() {
        try {
            Session session = this.borrowSession();
            String answer = super.toString() + " session: " + session.toString();
            this.returnSession(session);
            return answer;
        }
        catch (Exception e) {
            return super.toString() + " session: " + e.toString();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Destination getDestination(String subject) throws JMSException {
        Queue queue;
        Session session;
        block4: {
            Topic topic;
            block3: {
                session = this.borrowSession();
                try {
                    if (this.isTopic(session)) {
                        topic = this.getTopic((TopicSession)session, subject);
                        Object var5_5 = null;
                        break block3;
                    }
                    queue = this.getQueue((QueueSession)session, subject);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.returnSession(session);
                    throw throwable;
                }
            }
            this.returnSession(session);
            return topic;
        }
        Object var5_6 = null;
        this.returnSession(session);
        return queue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Destination createTemporaryDestination() throws JMSException {
        TemporaryQueue temporaryQueue;
        Session session;
        block4: {
            TemporaryTopic temporaryTopic;
            block3: {
                session = this.borrowSession();
                try {
                    if (this.isTopic(session)) {
                        TopicSession topicSession = (TopicSession)session;
                        temporaryTopic = topicSession.createTemporaryTopic();
                        Object var5_6 = null;
                        break block3;
                    }
                    QueueSession queueSession = (QueueSession)session;
                    temporaryQueue = queueSession.createTemporaryQueue();
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.returnSession(session);
                    throw throwable;
                }
            }
            this.returnSession(session);
            return temporaryTopic;
        }
        Object var5_7 = null;
        this.returnSession(session);
        return temporaryQueue;
    }

    public void send(Destination destination, Message message) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        try {
            producer = this.borrowMessageProducer(session, destination);
            if (this.isTopic(producer)) {
                ((TopicPublisher)producer).publish(message);
            } else {
                ((QueueSender)producer).send(message);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
    }

    public Message call(Destination destination, Message message) throws JMSException {
        Message message2;
        Session session = this.borrowSession();
        MessageProducer producer = null;
        try {
            Destination replyTo = this.getReplyToDestination();
            message.setJMSReplyTo(replyTo);
            producer = this.borrowMessageProducer(session, destination);
            MessageConsumer consumer = this.getReplyToConsumer();
            if (this.isTopic(producer)) {
                ((TopicPublisher)producer).publish(message);
            } else {
                ((QueueSender)producer).send(message);
            }
            Message response = consumer.receive();
            if (response == null) {
                this.clearReplyToDestination();
            }
            message2 = response;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
        return message2;
    }

    public Message call(Destination destination, Message message, long timeoutMillis) throws JMSException {
        Message message2;
        Session session = this.borrowSession();
        MessageProducer producer = null;
        try {
            Destination replyTo = this.getReplyToDestination();
            message.setJMSReplyTo(replyTo);
            producer = this.borrowMessageProducer(session, destination);
            MessageConsumer consumer = this.getReplyToConsumer();
            if (this.isTopic(producer)) {
                ((TopicPublisher)producer).publish(message);
            } else {
                ((QueueSender)producer).send(message);
            }
            Message response = consumer.receive(timeoutMillis);
            if (response == null) {
                this.clearReplyToDestination();
            }
            message2 = response;
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
        return message2;
    }

    public Message receive(Destination destination) throws JMSException {
        Message message;
        Session session = this.borrowSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, destination);
            message = consumer.receive();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageConsumer(consumer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnSession(session);
        return message;
    }

    public Message receive(Destination destination, String selector) throws JMSException {
        Message message;
        Session session = this.borrowSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, destination, selector);
            message = consumer.receive();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.returnMessageConsumer(consumer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnSession(session);
        return message;
    }

    public Message receive(Destination destination, long timeoutMillis) throws JMSException {
        Message message;
        Session session = this.borrowSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, destination);
            message = consumer.receive(timeoutMillis);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.returnMessageConsumer(consumer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnSession(session);
        return message;
    }

    public Message receive(Destination destination, String selector, long timeoutMillis) throws JMSException {
        Message message;
        Session session = this.borrowSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, destination, selector);
            message = consumer.receive(timeoutMillis);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.returnMessageConsumer(consumer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnSession(session);
        return message;
    }

    public Message receiveNoWait(Destination destination) throws JMSException {
        Message message;
        Session session = this.borrowSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, destination);
            message = consumer.receiveNoWait();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageConsumer(consumer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnSession(session);
        return message;
    }

    public Message receiveNoWait(Destination destination, String selector) throws JMSException {
        Message message;
        Session session = this.borrowSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, destination, selector);
            message = consumer.receiveNoWait();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.returnMessageConsumer(consumer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnSession(session);
        return message;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessageConsumer messageConsumer;
        Session session = this.borrowSession();
        try {
            messageConsumer = this.createMessageConsumer(session, destination);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return messageConsumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        MessageConsumer messageConsumer;
        Session session = this.borrowSession();
        try {
            messageConsumer = this.createMessageConsumer(session, destination, selector);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return messageConsumer;
    }

    public void run() {
        try {
            Session session = this.borrowSession();
            session.run();
            this.returnSession(session);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer(destination, null, sessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        Connection connection = this.getConnection();
        if (this.isTopic(connection)) {
            TopicConnection topicConnection = (TopicConnection)connection;
            if (this.isDurable()) {
                return topicConnection.createDurableConnectionConsumer((Topic)destination, this.getDurableName(), selector, sessionPool, maxMessages);
            }
            return topicConnection.createConnectionConsumer((Topic)destination, selector, sessionPool, maxMessages);
        }
        QueueConnection queueConnection = (QueueConnection)connection;
        return queueConnection.createConnectionConsumer((Queue)destination, selector, sessionPool, maxMessages);
    }

    public abstract Connection getConnection() throws JMSException;

    public void addListener(Destination destination, MessageListener listener) throws JMSException {
        if (listener instanceof MessengerListener) {
            MessengerListener messengerListener = (MessengerListener)listener;
            messengerListener.setMessenger(this);
        }
        Session session = this.borrowListenerSession();
        try {
            MessageConsumer consumer = this.createMessageConsumer(session, destination);
            consumer.setMessageListener(listener);
            ListenerKey key = new ListenerKey(destination, listener);
            this.listeners.put(key, consumer);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.returnListenerSession(session);
            throw throwable;
        }
        this.returnListenerSession(session);
    }

    public void addListener(Destination destination, String selector, MessageListener listener) throws JMSException {
        if (listener instanceof MessengerListener) {
            MessengerListener messengerListener = (MessengerListener)listener;
            messengerListener.setMessenger(this);
        }
        Session session = this.borrowListenerSession();
        try {
            MessageConsumer consumer = this.createMessageConsumer(session, destination, selector);
            consumer.setMessageListener(listener);
            ListenerKey key = new ListenerKey(destination, listener, selector);
            this.listeners.put(key, consumer);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.returnListenerSession(session);
            throw throwable;
        }
        this.returnListenerSession(session);
    }

    public void removeListener(Destination destination, MessageListener listener) throws JMSException {
        ListenerKey key = new ListenerKey(destination, listener);
        MessageConsumer consumer = (MessageConsumer)this.listeners.remove(key);
        if (consumer == null) {
            throw new JMSException("The given listener object has not been added for the given destination");
        }
        consumer.close();
    }

    public void removeListener(Destination destination, String selector, MessageListener listener) throws JMSException {
        ListenerKey key = new ListenerKey(destination, listener, selector);
        MessageConsumer consumer = (MessageConsumer)this.listeners.remove(key);
        if (consumer == null) {
            throw new JMSException("The given listener object has not been added for the given destination and selector");
        }
        consumer.close();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        BytesMessage bytesMessage;
        Session session = this.borrowSession();
        try {
            bytesMessage = session.createBytesMessage();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return bytesMessage;
    }

    public MapMessage createMapMessage() throws JMSException {
        MapMessage mapMessage;
        Session session = this.borrowSession();
        try {
            mapMessage = session.createMapMessage();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return mapMessage;
    }

    public Message createMessage() throws JMSException {
        Message message;
        Session session = this.borrowSession();
        try {
            message = session.createMessage();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessage objectMessage;
        Session session = this.borrowSession();
        try {
            objectMessage = session.createObjectMessage();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return objectMessage;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        ObjectMessage objectMessage;
        Session session = this.borrowSession();
        try {
            objectMessage = session.createObjectMessage(object);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return objectMessage;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        StreamMessage streamMessage;
        Session session = this.borrowSession();
        try {
            streamMessage = session.createStreamMessage();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return streamMessage;
    }

    public TextMessage createTextMessage() throws JMSException {
        TextMessage textMessage;
        Session session = this.borrowSession();
        try {
            textMessage = session.createTextMessage();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return textMessage;
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        TextMessage textMessage;
        Session session = this.borrowSession();
        try {
            textMessage = session.createTextMessage(text);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return textMessage;
    }

    public void commit() throws JMSException {
        Session session = this.borrowSession();
        try {
            session.commit();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
    }

    public void rollback() throws JMSException {
        Session session = this.borrowSession();
        try {
            session.rollback();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
    }

    public void close() throws JMSException {
        this.getSessionFactory().close();
    }

    public QueueBrowser createBrowser(Destination destination) throws JMSException {
        QueueBrowser queueBrowser;
        Session session = this.borrowSession();
        Object browser = null;
        try {
            queueBrowser = this.createBrowser(session, destination);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnSession(session);
            throw throwable;
        }
        this.returnSession(session);
        return queueBrowser;
    }

    public int getDeliveryMode(Destination destination) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        int deliveryMode = 0;
        try {
            producer = this.borrowMessageProducer(session, destination);
            deliveryMode = producer.getDeliveryMode();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
        return deliveryMode;
    }

    public void setDeliveryMode(Destination destination, int deliveryMode) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        try {
            producer = this.borrowMessageProducer(session, destination);
            producer.setDeliveryMode(deliveryMode);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
    }

    public int getPriority(Destination destination) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        int priority = 0;
        try {
            producer = this.borrowMessageProducer(session, destination);
            priority = producer.getPriority();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
        return priority;
    }

    public void setPriority(Destination destination, int priority) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        try {
            producer = this.borrowMessageProducer(session, destination);
            producer.setPriority(priority);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
    }

    public long getTimeToLive(Destination destination) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        long timeToLive = 0L;
        try {
            producer = this.borrowMessageProducer(session, destination);
            timeToLive = producer.getTimeToLive();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
        return timeToLive;
    }

    public void setTimeToLive(Destination destination, long timeToLive) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        try {
            producer = this.borrowMessageProducer(session, destination);
            producer.setTimeToLive(timeToLive);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
    }

    public boolean getDisableMessageTimestamp(Destination destination) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        boolean value = false;
        try {
            producer = this.borrowMessageProducer(session, destination);
            value = producer.getDisableMessageTimestamp();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
        return value;
    }

    public void setDisableMessageTimestamp(Destination destination, boolean value) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        try {
            producer = this.borrowMessageProducer(session, destination);
            producer.setDisableMessageTimestamp(value);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        try {
            producer = this.borrowMessageProducer(session, destination);
            if (this.isTopic(producer)) {
                ((TopicPublisher)producer).publish(message, deliveryMode, priority, timeToLive);
            } else {
                ((QueueSender)producer).send(message, deliveryMode, priority, timeToLive);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
    }

    public boolean getDisableMessageID(Destination destination) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        boolean value = false;
        try {
            producer = this.borrowMessageProducer(session, destination);
            value = producer.getDisableMessageID();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
        return value;
    }

    public void setDisableMessageID(Destination destination, boolean value) throws JMSException {
        Session session = this.borrowSession();
        MessageProducer producer = null;
        try {
            producer = this.borrowMessageProducer(session, destination);
            producer.setDisableMessageID(value);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageProducer(producer);
            this.returnSession(session);
            throw throwable;
        }
        this.returnMessageProducer(producer);
        this.returnSession(session);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setJndiDestinations(boolean jndiDestinations) {
        this.jndiDestinations = jndiDestinations;
    }

    public boolean isJndiDestinations() {
        return this.jndiDestinations;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isCacheRequestors() {
        return this.cacheRequestors;
    }

    public void setCacheRequestors(boolean cacheRequestors) {
        this.cacheRequestors = cacheRequestors;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void setDurableName(String durableName) {
        this.durableName = durableName;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isCacheProducers() {
        return this.cacheProducers;
    }

    public void setCacheProducers(boolean cacheProducers) {
        this.cacheProducers = cacheProducers;
    }

    protected abstract Session borrowSession() throws JMSException;

    protected abstract void returnSession(Session var1) throws JMSException;

    protected abstract Session borrowListenerSession() throws JMSException;

    protected abstract void returnListenerSession(Session var1) throws JMSException;

    protected abstract boolean isTopic(Connection var1) throws JMSException;

    protected abstract boolean isTopic(ConnectionFactory var1) throws JMSException;

    protected abstract boolean isTopic(Session var1) throws JMSException;

    protected abstract boolean isTopic(MessageProducer var1) throws JMSException;

    protected abstract MessengerSession getMessengerSession() throws JMSException;

    protected MessageProducer borrowMessageProducer(Session session, Destination destination) throws JMSException {
        if (this.isCacheProducers()) {
            return this.getMessengerSession().getMessageProducer(destination);
        }
        return this.createMessageProducer(session, destination);
    }

    protected void returnMessageProducer(MessageProducer producer) throws JMSException {
        if (!this.isCacheProducers()) {
            producer.close();
        }
    }

    protected MessageProducer createMessageProducer(Session session, Destination destination) throws JMSException {
        if (this.isTopic(session)) {
            TopicSession topicSession = (TopicSession)session;
            return topicSession.createPublisher((Topic)destination);
        }
        QueueSession queueSession = (QueueSession)session;
        return queueSession.createSender((Queue)destination);
    }

    protected MessageConsumer getReplyToConsumer() throws JMSException {
        MessengerSession messengerSession = this.getMessengerSession();
        MessageConsumer consumer = messengerSession.getReplyToConsumer();
        if (consumer == null) {
            consumer = this.createMessageConsumer(messengerSession.getSession(), messengerSession.getReplyToDestination());
            messengerSession.setReplyToConsumer(consumer);
        }
        return consumer;
    }

    protected void clearReplyToDestination() throws JMSException {
        MessengerSession messengerSession = this.getMessengerSession();
        messengerSession.setReplyToDestination(null);
        MessageConsumer consumer = messengerSession.getReplyToConsumer();
        if (consumer != null) {
            messengerSession.setReplyToConsumer(null);
            consumer.close();
        }
    }

    protected MessageConsumer borrowMessageConsumer(Session session, Destination destination) throws JMSException {
        return this.createMessageConsumer(session, destination);
    }

    protected MessageConsumer borrowMessageConsumer(Session session, Destination destination, String selector) throws JMSException {
        return this.createMessageConsumer(session, destination, selector);
    }

    protected void returnMessageConsumer(MessageConsumer messageConsumer) throws JMSException {
        if (messageConsumer != null) {
            messageConsumer.close();
        }
    }

    protected MessageConsumer createMessageConsumer(Session session, Destination destination) throws JMSException {
        if (this.isTopic(session)) {
            TopicSession topicSession = (TopicSession)session;
            if (this.isDurable()) {
                return topicSession.createDurableSubscriber((Topic)destination, this.getDurableName());
            }
            return topicSession.createSubscriber((Topic)destination);
        }
        QueueSession queueSession = (QueueSession)session;
        return queueSession.createReceiver((Queue)destination);
    }

    protected MessageConsumer createMessageConsumer(Session session, Destination destination, String selector) throws JMSException {
        if (this.isTopic(session)) {
            TopicSession topicSession = (TopicSession)session;
            if (this.isDurable()) {
                return topicSession.createDurableSubscriber((Topic)destination, this.getDurableName(), selector, this.isNoLocal());
            }
            return topicSession.createSubscriber((Topic)destination, selector, this.isNoLocal());
        }
        QueueSession queueSession = (QueueSession)session;
        return queueSession.createReceiver((Queue)destination, selector);
    }

    protected QueueBrowser createBrowser(Session session, Destination destination) throws JMSException {
        if (this.isTopic(session)) {
            return null;
        }
        QueueSession queueSession = (QueueSession)session;
        return queueSession.createBrowser((Queue)destination);
    }

    protected Queue getQueue(QueueSession session, String subject) throws JMSException {
        return session.createQueue(subject);
    }

    protected Topic getTopic(TopicSession session, String subject) throws JMSException {
        return session.createTopic(subject);
    }

    protected Destination getReplyToDestination() throws JMSException {
        return this.getMessengerSession().getReplyToDestination();
    }

    public abstract SessionFactory getSessionFactory() throws JMSException;

    public abstract ServerSessionPool createServerSessionPool(MessageListener var1, int var2) throws JMSException;
}

