/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger.tool;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.messenger.MessengerManager;
import org.apache.commons.messenger.tool.Producer;

public class Caller
extends Producer {
    public static void main(String[] args) {
        try {
            Caller client = new Caller();
            client.run(args);
        }
        catch (JMSException e) {
            System.out.println("Caught: " + (Object)((Object)e));
            Exception linked = e.getLinkedException();
            if (linked != null) {
                System.out.println("Underlying exception: " + linked);
                linked.printStackTrace();
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public void run(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: Caller messengerName destination [inputFileName] [outputFileName]");
            System.out.println("If no input file is used then System.in is used.");
            System.out.println("If no output file is used then System.out is used.");
            return;
        }
        String name = args[0];
        String subject = args[1];
        this.messenger = MessengerManager.get(name);
        if (this.messenger == null) {
            throw new JMSException("No such messenger called: " + name);
        }
        Destination destination = this.messenger.getDestination(subject);
        if (destination == null) {
            throw new JMSException("Could not find destination: " + subject);
        }
        InputStreamReader reader = args.length > 2 ? new FileReader(args[2]) : new InputStreamReader(System.in);
        OutputStreamWriter writer = args.length > 3 ? new FileWriter(args[3]) : new OutputStreamWriter(System.out);
        this.call(destination, reader, writer);
        this.messenger.close();
    }

    protected void call(Destination destination, Reader reader, Writer writer) throws Exception {
        Message request = this.createMessage(reader);
        Message response = this.messenger.call(destination, request);
        this.writeMessage(response, writer);
    }

    protected void writeMessage(Message message, Writer out) throws Exception {
        PrintWriter writer = new PrintWriter(out);
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            writer.println(textMessage.getText());
        }
        writer.close();
    }
}

