/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.naming;

import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class ResourceLinkRef
extends Reference {
    public static final String DEFAULT_FACTORY = "org.apache.commons.naming.factory.ResourceLinkFactory";
    public static final String GLOBALNAME = "globalName";

    public ResourceLinkRef(String resourceClass, String globalName) {
        this(resourceClass, globalName, null, null);
    }

    public ResourceLinkRef(String resourceClass, String globalName, String factory, String factoryLocation) {
        super(resourceClass, factory, factoryLocation);
        StringRefAddr refAddr = null;
        if (globalName != null) {
            refAddr = new StringRefAddr(GLOBALNAME, globalName);
            this.add(refAddr);
        }
    }

    public String getFactoryClassName() {
        String factory = super.getFactoryClassName();
        if (factory != null) {
            return factory;
        }
        factory = System.getProperty("java.naming.factory.object");
        if (factory != null) {
            return null;
        }
        return DEFAULT_FACTORY;
    }
}

