/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.commons.naming.TransactionRef;
import org.apache.commons.naming.factory.TyrexFactory;

public class TyrexTransactionFactory
extends TyrexFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        Reference ref;
        if (obj instanceof TransactionRef && (ref = (Reference)obj).getClassName().equals("javax.transaction.UserTransaction")) {
            try {
                return this.getTransactionDomain().getUserTransaction();
            }
            catch (Throwable t) {
                this.log("Cannot create Transaction, Exception", t);
                throw new NamingException("Exception creating Transaction: " + t.getMessage());
            }
        }
        return null;
    }

    private void log(String message) {
        System.out.print("TyrexTransactionFactory:  ");
        System.out.println(message);
    }

    private void log(String message, Throwable exception) {
        this.log(message);
        exception.printStackTrace(System.out);
    }
}

