/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.builder;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.sql.builder.SqlBuilder;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.ForeignKey;
import org.apache.commons.sql.model.Table;

public class MSSqlBuilder
extends SqlBuilder {
    public MSSqlBuilder() {
        this.setForeignKeyConstraintsNamed(true);
    }

    public void dropTable(Table table) throws IOException {
        String tableName = table.getName();
        int counter = 1;
        Iterator iter = table.getForeignKeys().iterator();
        while (iter.hasNext()) {
            ForeignKey key = (ForeignKey)iter.next();
            String constraintName = tableName + "_FK_" + counter;
            this.println("IF EXISTS (SELECT 1 FROM sysobjects WHERE type ='RI' AND name='" + constraintName + "'");
            this.printIndent();
            this.print("ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraintName);
            this.printEndOfStatement();
        }
        this.println("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = '" + tableName + "')");
        this.println("BEGIN");
        this.println("     DECLARE @reftable nvarchar(60), @constraintname nvarchar(60)");
        this.println("     DECLARE refcursor CURSOR FOR");
        this.println("     select reftables.name tablename, cons.name constraitname");
        this.println("      from sysobjects tables,");
        this.println("           sysobjects reftables,");
        this.println("           sysobjects cons,");
        this.println("           sysreferences ref");
        this.println("       where tables.id = ref.rkeyid");
        this.println("         and cons.id = ref.constid");
        this.println("         and reftables.id = ref.fkeyid");
        this.println("         and tables.name = '" + tableName + "'");
        this.println("     OPEN refcursor");
        this.println("     FETCH NEXT from refcursor into @reftable, @constraintname");
        this.println("     while @@FETCH_STATUS = 0");
        this.println("     BEGIN");
        this.println("       exec ('alter table '+@reftable+' drop constraint '+@constraintname)");
        this.println("       FETCH NEXT from refcursor into @reftable, @constraintname");
        this.println("     END");
        this.println("     CLOSE refcursor");
        this.println("     DEALLOCATE refcursor");
        this.println("     DROP TABLE " + tableName);
        this.print("END");
        this.printEndOfStatement();
    }

    protected void printComment(String text) throws IOException {
        this.print("# ");
        this.println(text);
    }

    protected void printAutoIncrementColumn(Table table, Column column) throws IOException {
        this.print("IDENTITY (1,1) ");
    }
}

