/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.builder;

import java.io.IOException;
import java.util.List;
import org.apache.commons.sql.builder.SqlBuilder;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.Table;

public class MySqlBuilder
extends SqlBuilder {
    public MySqlBuilder() {
        this.setForeignKeysEmbedded(true);
    }

    public void dropTable(Table table) throws IOException {
        this.print("drop table if exists ");
        this.print(table.getName());
        this.printEndOfStatement();
    }

    protected void printAutoIncrementColumn(Table table, Column column) throws IOException {
        this.print("AUTO_INCREMENT");
    }

    protected boolean shouldGeneratePrimaryKeys(List primaryKeyColumns) {
        return true;
    }

    protected String getNativeType(Column column) {
        if ("timestamp".equalsIgnoreCase(column.getType())) {
            return "DATETIME";
        }
        if ("longvarchar".equalsIgnoreCase(column.getType())) {
            return "TEXT";
        }
        return column.getType();
    }
}

