/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.builder;

import java.io.IOException;
import org.apache.commons.sql.builder.SqlBuilder;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.Table;

public class OracleBuilder
extends SqlBuilder {
    public OracleBuilder() {
        this.setPrimaryKeyEmbedded(false);
        this.setForeignKeyConstraintsNamed(true);
    }

    public void dropTable(Table table) throws IOException {
        this.print("drop table ");
        this.print(table.getName());
        this.print(" CASCADE CONSTRAINTS");
        this.printEndOfStatement();
    }

    protected void printComment(String text) throws IOException {
        this.print("--");
        if (!text.startsWith("-")) {
            this.print(" ");
        }
        this.println(text);
    }

    public void createTable(Table table) throws IOException {
        Column column = table.getAutoIncrementColumn();
        if (column != null) {
            this.createSequence(table, column);
        }
        super.createTable(table);
        if (column != null) {
            this.createSequenceTrigger(table, column);
        }
    }

    protected void printAutoIncrementColumn(Table table, Column column) throws IOException {
    }

    protected void createSequence(Table table, Column column) throws IOException {
        this.print("create sequence ");
        this.print(table.getName());
        this.print("_seq");
        this.printEndOfStatement();
    }

    protected void createSequenceTrigger(Table table, Column column) throws IOException {
        this.print("create or replace trigger ");
        this.print(table.getName());
        this.print("_trg before insert on ");
        this.println(table.getName());
        this.println("for each row");
        this.println("begin");
        this.print("select ");
        this.print(table.getName());
        this.print("_seq.nextval into :new.");
        this.print(column.getName());
        this.println(" from dual;");
        this.print("end");
        this.printEndOfStatement();
    }

    protected String getSqlType(Column column) {
        switch (column.getTypeCode()) {
            case 4: {
                return "INTEGER";
            }
            case 91: 
            case 92: 
            case 93: {
                return "DATE";
            }
        }
        return column.getType();
    }
}

