/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.builder;

import java.io.IOException;
import org.apache.commons.sql.builder.SqlBuilder;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.Table;

public class PostgreSqlBuilder
extends SqlBuilder {
    protected void printAutoIncrementColumn(Table table, Column column) throws IOException {
        this.print(" ");
        this.print("serial");
        this.print(" ");
    }

    public void createColumn(Table table, Column column) throws IOException {
        this.print(column.getName());
        this.print(" ");
        if (column.isAutoIncrement()) {
            this.printAutoIncrementColumn(table, column);
        } else {
            this.print(this.getSqlType(column));
            this.print(" ");
            if (column.getDefaultValue() != null) {
                this.print("DEFAULT '" + column.getDefaultValue() + "' ");
            }
            if (column.isRequired()) {
                this.printNotNullable();
            } else {
                this.printNullable();
            }
            this.print(" ");
        }
    }

    protected String getSqlType(Column column) {
        if (column.getTypeCode() == -3) {
            return "OID";
        }
        return super.getSqlType(column);
    }
}

