/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.builder;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.sql.io.JdbcModelReader;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.Database;
import org.apache.commons.sql.model.ForeignKey;
import org.apache.commons.sql.model.Index;
import org.apache.commons.sql.model.IndexColumn;
import org.apache.commons.sql.model.Reference;
import org.apache.commons.sql.model.Table;
import org.apache.commons.sql.model.TypeMap;

public class SqlBuilder {
    private static final String LINE_SEP = System.getProperty("line.separator", "\n");
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$sql$builder$SqlBuilder == null ? (class$org$apache$commons$sql$builder$SqlBuilder = SqlBuilder.class$("org.apache.commons.sql.builder.SqlBuilder")) : class$org$apache$commons$sql$builder$SqlBuilder));
    private Writer writer;
    private int counter;
    private String indent = "    ";
    private boolean primaryKeyEmbedded = true;
    private boolean foreignKeysEmbedded;
    private boolean indexesEmbedded;
    private boolean foreignKeyConstraintsNamed;
    private boolean alterTableForDrop;
    static /* synthetic */ Class class$org$apache$commons$sql$builder$SqlBuilder;

    public void createDatabase(Database database) throws IOException {
        this.createDatabase(database, true);
    }

    public void createDatabase(Database database, boolean dropTable) throws IOException {
        if (dropTable) {
            List tables = database.getTables();
            for (int i = tables.size() - 1; i >= 0; --i) {
                Table table = (Table)tables.get(i);
                this.dropTable(table);
            }
        }
        Iterator iter = database.getTables().iterator();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            this.tableComment(table);
            this.createTable(table);
        }
    }

    public void dropDatabase(Database database) throws IOException {
        List tables = database.getTables();
        for (int i = tables.size() - 1; i >= 0; --i) {
            Table table = (Table)tables.get(i);
            this.tableComment(table);
            this.dropTable(table);
        }
    }

    public void tableComment(Table table) throws IOException {
        this.printComment("-----------------------------------------------------------------------");
        this.printComment(table.getName());
        this.printComment("-----------------------------------------------------------------------");
        this.println();
    }

    public void dropTable(Table table) throws IOException {
        this.print("drop table ");
        this.print(table.getName());
        this.printEndOfStatement();
    }

    public void createTable(Table table) throws IOException {
        this.print("create table ");
        this.println(table.getName());
        this.println("(");
        this.writeColumnTypes(table);
        if (this.isPrimaryKeyEmbedded()) {
            this.writePrimaryKeys(table);
        }
        if (this.isForeignKeysEmbedded()) {
            this.writeForeignKeys(table);
        }
        if (this.isIndexesEmbedded()) {
            this.writeEmbeddedIndexes(table);
        }
        this.println();
        this.print(")");
        this.printEndOfStatement();
        if (!this.isPrimaryKeyEmbedded()) {
            this.writePrimaryKeysAlterTable(table);
        }
        if (!this.isForeignKeysEmbedded()) {
            this.writeForeignKeysAlterTable(table);
        }
        if (!this.isIndexesEmbedded()) {
            this.writeIndexes(table);
        }
    }

    public void createColumn(Table table, Column column) throws IOException {
        this.print(column.getName());
        this.print(" ");
        this.print(this.getSqlType(column));
        this.print(" ");
        if (column.getDefaultValue() != null) {
            this.print("DEFAULT '" + column.getDefaultValue() + "' ");
        }
        if (column.isRequired()) {
            this.printNotNullable();
        } else {
            this.printNullable();
        }
        this.print(" ");
        if (column.isAutoIncrement()) {
            this.printAutoIncrementColumn(table, column);
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public boolean isPrimaryKeyEmbedded() {
        return this.primaryKeyEmbedded;
    }

    public void setPrimaryKeyEmbedded(boolean primaryKeyEmbedded) {
        this.primaryKeyEmbedded = primaryKeyEmbedded;
    }

    public boolean isForeignKeysEmbedded() {
        return this.foreignKeysEmbedded;
    }

    public void setForeignKeysEmbedded(boolean foreignKeysEmbedded) {
        this.foreignKeysEmbedded = foreignKeysEmbedded;
    }

    public boolean isIndexesEmbedded() {
        return this.indexesEmbedded;
    }

    public void setIndexesEmbedded(boolean indexesEmbedded) {
        this.indexesEmbedded = indexesEmbedded;
    }

    public boolean isForeignKeyConstraintsNamed() {
        return this.foreignKeyConstraintsNamed;
    }

    public void setForeignKeyConstraintsNamed(boolean foreignKeyConstraintsNamed) {
        this.foreignKeyConstraintsNamed = foreignKeyConstraintsNamed;
    }

    protected boolean shouldGeneratePrimaryKeys(List primaryKeyColumns) {
        Iterator iter = primaryKeyColumns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (column.isAutoIncrement()) continue;
            return true;
        }
        return false;
    }

    protected String getSqlType(Column column) {
        StringBuffer sqlType = new StringBuffer(this.getNativeType(column));
        if (column.getSize() > 0) {
            sqlType.append(" (");
            sqlType.append(column.getSize());
            if (TypeMap.isDecimalType(column.getType())) {
                sqlType.append(",");
                sqlType.append(column.getScale());
            }
            sqlType.append(")");
        }
        return sqlType.toString();
    }

    protected void writeColumnTypes(Table table) throws IOException {
        boolean first = true;
        Iterator iter = table.getColumns().iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (first) {
                first = false;
            } else {
                this.println(",");
            }
            this.printIndent();
            this.createColumn(table, column);
        }
    }

    protected void writePrimaryKeys(Table table) throws IOException {
        List primaryKeyColumns = table.getPrimaryKeyColumns();
        if (primaryKeyColumns.size() > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.println(",");
            this.printIndent();
            this.writePrimaryKeyStatement(primaryKeyColumns);
        }
    }

    protected void writePrimaryKeysAlterTable(Table table) throws IOException {
        List primaryKeyColumns = table.getPrimaryKeyColumns();
        if (primaryKeyColumns.size() > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.print("ALTER TABLE ");
            this.println(table.getName());
            this.printIndent();
            this.print("ADD CONSTRAINT ");
            this.print(table.getName());
            this.println("_PK");
            this.writePrimaryKeyStatement(primaryKeyColumns);
            this.printEndOfStatement();
            this.println();
        }
    }

    protected void writePrimaryKeyStatement(List primaryKeyColumns) throws IOException {
        this.print("PRIMARY KEY (");
        boolean first = true;
        Iterator iter = primaryKeyColumns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (first) {
                first = false;
            } else {
                this.print(", ");
            }
            this.print(column.getName());
        }
        this.print(")");
    }

    protected void writeForeignKeys(Table table) throws IOException {
        Iterator keyIter = table.getForeignKeys().iterator();
        while (keyIter.hasNext()) {
            ForeignKey key = (ForeignKey)keyIter.next();
            if (key.getForeignTable() == null) {
                log.warn((Object)("Foreign key table is null for key: " + key));
                continue;
            }
            this.println(",");
            this.printIndent();
            if (this.isForeignKeyConstraintsNamed()) {
                this.print("CONSTRAINT ");
                this.print(table.getName());
                this.print("_FK_");
                this.print(Integer.toString(++this.counter));
                this.print(" ");
            }
            this.print("FOREIGN KEY (");
            this.writeLocalReferences(key);
            this.println(")");
            this.printIndent();
            this.print("REFERENCES ");
            this.print(key.getForeignTable());
            this.print(" (");
            this.writeForeignReferences(key);
            this.println(")");
        }
    }

    protected void writeForeignKeysAlterTable(Table table) throws IOException {
        this.counter = 0;
        Iterator keyIter = table.getForeignKeys().iterator();
        while (keyIter.hasNext()) {
            ForeignKey key = (ForeignKey)keyIter.next();
            this.writeForeignKeyAlterTable(table, key);
        }
    }

    protected void writeForeignKeyAlterTable(Table table, ForeignKey key) throws IOException {
        if (key.getForeignTable() == null) {
            log.warn((Object)("Foreign key table is null for key: " + key));
        } else {
            this.print("ALTER TABLE ");
            this.println(table.getName());
            this.printIndent();
            this.print("ADD CONSTRAINT ");
            this.print(table.getName());
            this.print("_FK_");
            this.print(Integer.toString(++this.counter));
            this.print(" FOREIGN KEY (");
            this.writeLocalReferences(key);
            this.println(")");
            this.printIndent();
            this.print("REFERENCES ");
            this.print(key.getForeignTable());
            this.print(" (");
            this.writeForeignReferences(key);
            this.println(")");
            this.printEndOfStatement();
        }
    }

    protected void writeIndexes(Table table) throws IOException {
        Iterator indexIter = table.getIndexes().iterator();
        while (indexIter.hasNext()) {
            Index index = (Index)indexIter.next();
            this.writeIndex(table, index);
        }
    }

    protected void writeIndex(Table table, Index index) throws IOException {
        if (index.getName() == null) {
            log.warn((Object)("Index Name is null for index: " + index));
        } else {
            this.print("CREATE");
            if (index.isUnique()) {
                this.print(" UNIQUE");
            }
            this.print(" INDEX ");
            this.print(index.getName());
            this.print(" ON ");
            this.print(table.getName());
            this.print(" (");
            Iterator idxColumnIter = index.getIndexColumns().iterator();
            while (idxColumnIter.hasNext()) {
                IndexColumn idxColumn = (IndexColumn)idxColumnIter.next();
                if (idxColumnIter.hasNext()) {
                    this.print(idxColumn.getName() + ", ");
                    continue;
                }
                this.print(idxColumn.getName());
            }
            this.print(")");
            this.printEndOfStatement();
        }
    }

    protected void writeEmbeddedIndexes(Table table) throws IOException {
    }

    protected void writeLocalReferences(ForeignKey key) throws IOException {
        boolean first = true;
        Iterator iter = key.getReferences().iterator();
        while (iter.hasNext()) {
            Reference reference = (Reference)iter.next();
            if (first) {
                first = false;
            } else {
                this.print(", ");
            }
            this.print(reference.getLocal());
        }
    }

    protected void writeForeignReferences(ForeignKey key) throws IOException {
        boolean first = true;
        Iterator iter = key.getReferences().iterator();
        while (iter.hasNext()) {
            Reference reference = (Reference)iter.next();
            if (first) {
                first = false;
            } else {
                this.print(", ");
            }
            this.print(reference.getForeign());
        }
    }

    protected void printComment(String text) throws IOException {
        this.print("--");
        this.print(" ");
        this.println(text);
    }

    protected void printNullable() throws IOException {
        this.print("NULL");
    }

    protected void printNotNullable() throws IOException {
        this.print("NOT NULL");
    }

    protected void printEndOfStatement() throws IOException {
        this.println(";");
        this.println();
    }

    protected void println() throws IOException {
        this.print(LINE_SEP);
    }

    protected void print(String text) throws IOException {
        this.writer.write(text);
    }

    protected void println(String text) throws IOException {
        this.print(text);
        this.println();
    }

    protected void printIndent() throws IOException {
        this.print(this.getIndent());
    }

    protected void printAutoIncrementColumn(Table table, Column column) throws IOException {
        this.print("IDENTITY");
    }

    protected String getNativeType(Column column) {
        return column.getType();
    }

    public void alterDatabase(Database desiredDb, Connection cn) throws IOException, SQLException {
        this.alterDatabase(desiredDb, cn, false, false);
    }

    public void alterDatabase(Database desiredDb, Connection cn, boolean doDrops, boolean modifyColumns) throws IOException, SQLException {
        Database currentDb = new JdbcModelReader(cn).getDatabase();
        Iterator iter = desiredDb.getTables().iterator();
        while (iter.hasNext()) {
            Table desiredTable = (Table)iter.next();
            Table currentTable = currentDb.findTable(desiredTable.getName());
            if (currentTable == null) {
                log.info((Object)("creating table " + desiredTable.getName()));
                this.createTable(desiredTable);
                continue;
            }
            Iterator desiredColumns = desiredTable.getColumns().iterator();
            while (desiredColumns.hasNext()) {
                Column desiredColumn = (Column)desiredColumns.next();
                Column currentColumn = currentTable.findColumn(desiredColumn.getName());
                if (null == currentColumn) {
                    log.info((Object)("creating column " + desiredTable.getName() + "." + desiredColumn.getName()));
                    this.alterColumn(desiredTable, desiredColumn, true);
                    continue;
                }
                if (!this.columnsDiffer(desiredColumn, currentColumn)) continue;
                if (modifyColumns) {
                    log.info((Object)("altering column " + desiredTable.getName() + "." + desiredColumn.getName()));
                    log.info((Object)("  desiredColumn=" + desiredColumn.toStringAll()));
                    log.info((Object)("  currentColumn=" + currentColumn.toStringAll()));
                    this.alterColumn(desiredTable, desiredColumn, false);
                    continue;
                }
                String text = "Column " + currentColumn.getName() + " in table " + currentTable.getName() + " differs from current specification";
                log.info((Object)text);
                this.printComment(text);
            }
            Iterator desiredIndexes = desiredTable.getIndexes().iterator();
            while (desiredIndexes.hasNext()) {
                Index desiredIndex = (Index)desiredIndexes.next();
                Index currentIndex = currentTable.findIndex(desiredIndex.getName());
                if (null != currentIndex) continue;
                log.info((Object)("creating index " + desiredTable.getName() + "." + desiredIndex.getName()));
                this.writeIndex(desiredTable, desiredIndex);
            }
            Iterator currentColumns = currentTable.getColumns().iterator();
            while (currentColumns.hasNext()) {
                Column currentColumn = (Column)currentColumns.next();
                Column desiredColumn = desiredTable.findColumn(currentColumn.getName());
                if (null != desiredColumn) continue;
                if (doDrops) {
                    log.info((Object)("dropping column " + currentTable.getName() + "." + currentColumn.getName()));
                    this.dropColumn(currentTable, currentColumn);
                    continue;
                }
                String text = "Column " + currentColumn.getName() + " can be dropped from table " + currentTable.getName();
                log.info((Object)text);
                this.printComment(text);
            }
            Iterator currentIndexes = currentTable.getIndexes().iterator();
            while (currentIndexes.hasNext()) {
                Index currentIndex = (Index)currentIndexes.next();
                Index desiredIndex = desiredTable.findIndex(currentIndex.getName());
                if (null != desiredIndex) continue;
                Iterator indexColumns = currentIndex.getIndexColumns().iterator();
                boolean isPk = true;
                while (indexColumns.hasNext()) {
                    IndexColumn ic = (IndexColumn)indexColumns.next();
                    Column c = currentTable.findColumn(ic.getName());
                    if (c.isPrimaryKey()) continue;
                    isPk = false;
                    break;
                }
                if (isPk) continue;
                log.info((Object)("dropping non-primary index " + currentTable.getName() + "." + currentIndex.getName()));
                this.dropIndex(currentTable, currentIndex);
            }
        }
        iter = currentDb.getTables().iterator();
        while (iter.hasNext()) {
            Table currentTable = (Table)iter.next();
            Table desiredTable = desiredDb.findTable(currentTable.getName());
            if (desiredTable != null) continue;
            if (doDrops) {
                log.info((Object)("dropping table " + currentTable.getName()));
                this.dropTable(currentTable);
                continue;
            }
            String text = "Table " + currentTable.getName() + " can be dropped";
            log.info((Object)text);
            this.printComment(text);
        }
    }

    public void alterColumn(Table table, Column column, boolean add) throws IOException {
        this.writeAlterHeader(table);
        this.print(add ? "ADD " : "MODIFY ");
        this.createColumn(table, column);
        this.printEndOfStatement();
    }

    public void dropColumn(Table table, Column column) throws IOException {
        this.writeAlterHeader(table);
        this.print("DROP COLUMN ");
        this.print(column.getName());
        this.printEndOfStatement();
    }

    protected void writeAlterHeader(Table table) throws IOException {
        this.print("ALTER TABLE ");
        this.println(table.getName());
        this.printIndent();
    }

    public void dropIndex(Table table, Index index) throws IOException {
        if (this.useAlterTableForDrop()) {
            this.writeAlterHeader(table);
        }
        this.print("DROP INDEX ");
        this.print(index.getName());
        if (!this.useAlterTableForDrop()) {
            this.print(" ON ");
            this.print(table.getName());
        }
        this.printEndOfStatement();
    }

    protected boolean columnsDiffer(Column desired, Column current) {
        boolean sizeMatters;
        boolean result = false;
        String desiredDefault = desired.getDefaultValue();
        String currentDefault = current.getDefaultValue();
        boolean defaultsEqual = desiredDefault == null || desiredDefault.equals(currentDefault);
        boolean bl = sizeMatters = desired.getSize() > 0;
        if (desired.getTypeCode() != current.getTypeCode() || desired.isRequired() != current.isRequired() || sizeMatters && desired.getSize() != current.getSize() || desired.getScale() != current.getScale() || !defaultsEqual || desired.getPrecisionRadix() != current.getPrecisionRadix()) {
            result = true;
        }
        return result;
    }

    public boolean useAlterTableForDrop() {
        return this.alterTableForDrop;
    }

    public void setAlterTableForDrop(boolean alterTableForDrop) {
        this.alterTableForDrop = alterTableForDrop;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

