/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.builder;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.sql.builder.SqlBuilder;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.ForeignKey;
import org.apache.commons.sql.model.Table;

public class SybaseBuilder
extends SqlBuilder {
    public SybaseBuilder() {
        this.setForeignKeyConstraintsNamed(true);
    }

    public void dropTable(Table table) throws IOException {
        String tableName = table.getName();
        int counter = 1;
        Iterator iter = table.getForeignKeys().iterator();
        while (iter.hasNext()) {
            ForeignKey key = (ForeignKey)iter.next();
            String constraintName = tableName + "_FK_" + counter;
            this.println("IF EXISTS (SELECT 1 FROM sysobjects WHERE type ='RI' AND name=''" + constraintName + "')");
            this.printIndent();
            this.print("ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraintName);
            this.printEndOfStatement();
        }
        this.println("IF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = '" + tableName + "')");
        this.println("BEGIN");
        this.printIndent();
        this.println("DROP TABLE " + tableName);
        this.print("END");
        this.printEndOfStatement();
    }

    protected void printComment(String text) throws IOException {
        this.print("/* ");
        this.print(text);
        this.println(" */");
    }

    protected void printAutoIncrementColumn(Table table, Column column) throws IOException {
    }
}

