/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.ddl;

import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.sql.ddl.DatabaseMapper;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.Database;
import org.apache.commons.sql.model.ForeignKey;
import org.apache.commons.sql.model.Reference;
import org.apache.commons.sql.model.Table;
import org.apache.commons.sql.type.Types;

public abstract class AbstractDatabaseMapper
implements DatabaseMapper {
    private Database database;
    private Types types;

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setTypes(Types types) {
        this.types = types;
    }

    public Types getTypes() {
        return this.types;
    }

    public Database map() throws SQLException {
        Iterator tables = this.database.getTables().iterator();
        while (tables.hasNext()) {
            this.map((Table)tables.next());
        }
        return this.database;
    }

    protected Table map(Table table) throws SQLException {
        Iterator columns = table.getColumns().iterator();
        while (columns.hasNext()) {
            this.map(table, (Column)columns.next());
        }
        Iterator foreignKeys = table.getForeignKeys().iterator();
        while (foreignKeys.hasNext()) {
            this.map(table, (ForeignKey)foreignKeys.next());
        }
        return table;
    }

    protected Column map(Table table, Column column) throws SQLException {
        return column;
    }

    protected ForeignKey map(Table table, ForeignKey key) throws SQLException {
        Iterator references = key.getReferences().iterator();
        while (references.hasNext()) {
            this.map(table, (Reference)references.next());
        }
        return key;
    }

    protected Reference map(Table table, Reference reference) throws SQLException {
        return reference;
    }
}

