/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.ddl;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.sql.SQLException;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.sql.ddl.DefaultDatabaseMapper;
import org.apache.commons.sql.ddl.ProviderVersion;
import org.apache.commons.sql.model.Database;
import org.apache.commons.sql.type.Types;
import org.apache.commons.sql.type.TypesReader;

public class DDLBuilder {
    private Writer writer;
    private ProviderVersion provider;
    private URL taglibPath;
    private URL basePath;
    private Types types;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$sql$ddl$DDLBuilder == null ? (class$org$apache$commons$sql$ddl$DDLBuilder = DDLBuilder.class$("org.apache.commons.sql.ddl.DDLBuilder")) : class$org$apache$commons$sql$ddl$DDLBuilder));
    private static final String DATABASE_VAR = "database";
    private static final String TAGLIB_VAR = "commons_sql.taglib";
    private static final String TYPES_VAR = "types";
    static /* synthetic */ Class class$org$apache$commons$sql$ddl$DDLBuilder;

    public DDLBuilder(ProviderVersion provider, URL taglibPath, URL basePath) throws IOException {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 'provider' is null");
        }
        if (taglibPath == null) {
            throw new IllegalArgumentException("Argument 'taglibPath' is null");
        }
        if (basePath == null) {
            throw new IllegalArgumentException("Argument 'basePath' is null");
        }
        this.provider = provider;
        this.taglibPath = taglibPath;
        this.basePath = basePath;
        URL path = new URL(this.getPath(provider.getTypes()));
        this.types = TypesReader.read(path);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void createDatabase(Database database) throws IOException, SQLException {
        this.createDatabase(database, true);
    }

    public void createDatabase(Database database, boolean dropTable) throws IOException, SQLException {
        database = this.map(database);
        JellyContext context = new JellyContext();
        context.setVariable(DATABASE_VAR, (Object)database);
        context.setVariable(TAGLIB_VAR, (Object)this.taglibPath.toString());
        context.setVariable(TYPES_VAR, (Object)this.types);
        Writer writer = this.getWriter();
        XMLOutput output = XMLOutput.createXMLOutput((Writer)writer);
        String script = this.getPath(this.provider.getCreateScript());
        try {
            context.runScript(script, output);
            writer.flush();
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void dropDatabase(Database database) throws IOException, SQLException {
        database = this.map(database);
        JellyContext context = new JellyContext();
        context.setVariable(DATABASE_VAR, (Object)database);
        context.setVariable(TAGLIB_VAR, (Object)this.taglibPath.toString());
        context.setVariable(TYPES_VAR, (Object)this.types);
        Writer writer = this.getWriter();
        XMLOutput output = XMLOutput.createXMLOutput((Writer)writer);
        String script = this.getPath(this.provider.getDropScript());
        try {
            context.runScript(script, output);
            writer.flush();
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private Database map(Database database) throws SQLException {
        DefaultDatabaseMapper mapper = new DefaultDatabaseMapper();
        mapper.setDatabase(database);
        mapper.setTypes(this.types);
        return mapper.map();
    }

    private String getPath(String resource) {
        String result = this.basePath.toString();
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        result = result + resource;
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

