/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.ddl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.sql.ddl.DDLBuilder;
import org.apache.commons.sql.ddl.Provider;
import org.apache.commons.sql.ddl.ProviderVersion;
import org.apache.commons.sql.ddl.Providers;
import org.apache.commons.sql.ddl.ProvidersReader;

public class DDLBuilderFactory {
    private static URL taglibPath;
    private static URL basePath;
    private static Providers providers;
    private static final String RESOURCE_PATH = "/META-INF/commons-sql/";
    private static final String TAGLIB_PATH = "/META-INF/commons-sql/taglib.jelly";
    private static final String PROVIDERS_PATH = "/META-INF/commons-sql/providers.xml";
    private static final Log log;
    static /* synthetic */ Class class$org$apache$commons$sql$ddl$DDLBuilderFactory;

    public static synchronized DDLBuilder newDDLBuilder(String name) throws IOException {
        return DDLBuilderFactory.newDDLBuilder(name, null);
    }

    public static synchronized DDLBuilder newDDLBuilder(String name, String version) throws IOException {
        ProviderVersion providerVersion;
        Provider provider;
        DDLBuilder result = null;
        if (providers == null) {
            DDLBuilderFactory.init();
        }
        if ((provider = providers.getProvider(name)) != null && (providerVersion = provider.getProviderVersion(version)) != null) {
            result = new DDLBuilder(providerVersion, taglibPath, basePath);
        }
        return result;
    }

    public static synchronized List getProviders() throws IOException {
        if (providers == null) {
            DDLBuilderFactory.init();
        }
        return providers.getProviders();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void init() throws IOException {
        URL url;
        block11: {
            taglibPath = (class$org$apache$commons$sql$ddl$DDLBuilderFactory == null ? (class$org$apache$commons$sql$ddl$DDLBuilderFactory = DDLBuilderFactory.class$("org.apache.commons.sql.ddl.DDLBuilderFactory")) : class$org$apache$commons$sql$ddl$DDLBuilderFactory).getResource(TAGLIB_PATH);
            if (taglibPath == null) {
                String message = "Failed to locate core tag library, path=/META-INF/commons-sql/taglib.jelly";
                throw new IOException(message);
            }
            url = (class$org$apache$commons$sql$ddl$DDLBuilderFactory == null ? (class$org$apache$commons$sql$ddl$DDLBuilderFactory = DDLBuilderFactory.class$("org.apache.commons.sql.ddl.DDLBuilderFactory")) : class$org$apache$commons$sql$ddl$DDLBuilderFactory).getResource(PROVIDERS_PATH);
            if (url == null) {
                String message = "Failed to locate providers, path=/META-INF/commons-sql/providers.xml";
                throw new IOException(message);
            }
            InputStream stream = null;
            try {
                try {
                    stream = url.openStream();
                    ProvidersReader reader = new ProvidersReader();
                    providers = (Providers)reader.parse(stream);
                }
                catch (IOException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    String message = "Failed to load providers, path=/META-INF/commons-sql/providers.xml";
                    throw new IOException(message + ": " + exception.getMessage());
                }
                Object var5_7 = null;
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignore) {}
            stream.close();
        }
        if (providers == null) {
            throw new IOException("Failed to load providers, path=/META-INF/commons-sql/providers.xml");
        }
        String path = url.toString();
        basePath = new URL(path.substring(0, path.lastIndexOf("/") + 1));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$org$apache$commons$sql$ddl$DDLBuilderFactory == null ? (class$org$apache$commons$sql$ddl$DDLBuilderFactory = DDLBuilderFactory.class$("org.apache.commons.sql.ddl.DDLBuilderFactory")) : class$org$apache$commons$sql$ddl$DDLBuilderFactory));
    }
}

