/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.ddl;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.sql.ddl.AbstractDatabaseMapper;
import org.apache.commons.sql.ddl.ModelHelper;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.Database;
import org.apache.commons.sql.model.Reference;
import org.apache.commons.sql.model.Table;
import org.apache.commons.sql.type.Mapping;
import org.apache.commons.sql.type.TypeMapping;
import org.apache.commons.sql.type.Types;

public class DefaultDatabaseMapper
extends AbstractDatabaseMapper {
    public Database map() throws SQLException {
        Database database = this.getDatabase();
        Iterator tables = database.getTables().iterator();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            if (table.getAutoIncrementColumn() == null) continue;
            this.mapAutoIncrementColumn(table);
        }
        return super.map();
    }

    protected Column map(Table table, Column column) throws SQLException {
        if (!column.isAutoIncrement()) {
            this.mapColumn(table, column);
        }
        return super.map(table, column);
    }

    protected void mapColumn(Table table, Column column) throws SQLException {
        int size;
        String name;
        Types types = this.getTypes();
        TypeMapping mapping = types.getTypeMapping(name = column.getType(), (long)(size = column.getSize()));
        if (mapping == null) {
            mapping = types.promote(name, size);
        }
        if (mapping == null) {
            throw new SQLException("Column not supported: " + column);
        }
        if (mapping.getSize() != 0L && (long)column.getSize() > mapping.getSize()) {
            throw new SQLException("Column exceeds size of type: " + column);
        }
        this.promoteColumn(table, column, mapping);
    }

    protected void mapAutoIncrementColumn(Table table) throws SQLException {
        Types types = this.getTypes();
        Column column = table.getAutoIncrementColumn();
        String name = column.getType();
        int size = column.getSize();
        if (!types.getAutoIncrementMappings().isEmpty()) {
            TypeMapping mapping = types.getAutoIncrementMapping(name, size);
            if (mapping == null) {
                Mapping autoIncMapping;
                TypeMapping promoted = null;
                Iterator mappings = types.getAutoIncrementMappings().iterator();
                while (mappings.hasNext() && (promoted = types.promote(name, (autoIncMapping = (Mapping)mappings.next()).getName(), size)) == null) {
                }
                if (promoted == null) {
                    throw new SQLException("Auto-increment column " + column + " not supported by database");
                }
                this.promoteColumn(table, column, promoted);
            }
        } else {
            this.mapColumn(table, column);
        }
    }

    protected void promoteColumn(Table table, Column column, TypeMapping mapping) {
        column.setType(mapping.getName());
        if (mapping.getSize() < (long)column.getSize()) {
            column.setSize((int)mapping.getSize());
        }
        Database database = this.getDatabase();
        Iterator tables = database.getTables().iterator();
        while (tables.hasNext()) {
            Table referencingTable = (Table)tables.next();
            List references = ModelHelper.getReferences(referencingTable, table, column.getName());
            Iterator iterator = references.iterator();
            while (iterator.hasNext()) {
                Reference reference = (Reference)iterator.next();
                Column referencingColumn = ModelHelper.getColumn(referencingTable, reference.getLocal());
                referencingColumn.setType(column.getType());
                referencingColumn.setSize(column.getSize());
            }
        }
    }
}

