/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.ForeignKey;
import org.apache.commons.sql.model.Reference;
import org.apache.commons.sql.model.Table;

public class ModelHelper {
    public static Column getColumn(Table table, String name) {
        Column result = null;
        Iterator columns = table.getColumns().iterator();
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            if (!column.getName().equalsIgnoreCase(name)) continue;
            result = column;
            break;
        }
        return result;
    }

    public static List getReferences(Table referencer, Table referenced, String name) {
        List result = Collections.EMPTY_LIST;
        List foreignKeys = ModelHelper.getReferences(referencer, referenced);
        if (!foreignKeys.isEmpty()) {
            result = ModelHelper.getReferences(foreignKeys, name);
        }
        return result;
    }

    public static List getReferences(Table referencer, Table referenced) {
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        Iterator keys = referencer.getForeignKeys().iterator();
        String name = referenced.getName();
        while (keys.hasNext()) {
            ForeignKey key = (ForeignKey)keys.next();
            if (!key.getForeignTable().equalsIgnoreCase(name)) continue;
            result.add(key);
        }
        return result;
    }

    public static List getReferences(List foreignKeys, String name) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        Iterator keys = foreignKeys.iterator();
        while (keys.hasNext()) {
            ForeignKey key = (ForeignKey)keys.next();
            Iterator references = key.getReferences().iterator();
            while (references.hasNext()) {
                Reference reference = (Reference)references.next();
                if (!reference.getForeign().equalsIgnoreCase(name)) continue;
                result.add(reference);
            }
        }
        return result;
    }
}

