/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.dynabean;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.ResultSetDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.sql.dynabean.SqlDynaClass;
import org.apache.commons.sql.dynabean.SqlDynaProperty;
import org.apache.commons.sql.model.Database;
import org.apache.commons.sql.model.Table;
import org.apache.commons.sql.util.JdbcSupport;

public class DynaSql
extends JdbcSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$sql$dynabean$DynaSql == null ? (class$org$apache$commons$sql$dynabean$DynaSql = DynaSql.class$("org.apache.commons.sql.dynabean.DynaSql")) : class$org$apache$commons$sql$dynabean$DynaSql));
    private Database database;
    private Map dynaClassCache = new HashMap();
    static /* synthetic */ Class class$org$apache$commons$sql$dynabean$DynaSql;

    public DynaSql() {
    }

    public DynaSql(DataSource dataSource, Database database) {
        super(dataSource);
        this.database = database;
    }

    public DynaBean newInstance(String tableName) throws IllegalAccessException, InstantiationException {
        SqlDynaClass dynaClass = this.getDynaClass(tableName);
        if (dynaClass != null) {
            return dynaClass.newInstance();
        }
        return null;
    }

    public DynaBean copy(String tableName, Object source) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        DynaBean answer = this.newInstance(tableName);
        BeanUtils.copyProperties((Object)answer, (Object)source);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator query(String sql) throws SQLException, IllegalAccessException, InstantiationException {
        Iterator answer = null;
        Connection connection = this.borrowConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            Iterator iterator = answer = this.createResultSetIterator(connection, statement, resultSet);
            Object var8_7 = null;
            if (answer == null) {
                this.closeResources(connection, statement, resultSet);
            }
            return iterator;
        }
        catch (Throwable throwable) {
            block3: {
                Object var8_8 = null;
                if (answer != null) break block3;
                this.closeResources(connection, statement, resultSet);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator query(String sql, List parameters) throws SQLException, IllegalAccessException, InstantiationException {
        Iterator answer = null;
        Connection connection = this.borrowConnection();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(sql);
            int paramIdx = 1;
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                Object param = iter.next();
                statement.setObject(paramIdx++, param);
            }
            resultSet = statement.executeQuery();
            Iterator iterator = answer = this.createResultSetIterator(connection, statement, resultSet);
            Object var11_10 = null;
            if (answer == null) {
                this.closeResources(connection, statement, resultSet);
            }
            return iterator;
        }
        catch (Throwable throwable) {
            block4: {
                Object var11_11 = null;
                if (answer != null) break block4;
                this.closeResources(connection, statement, resultSet);
            }
            throw throwable;
        }
    }

    public SqlDynaClass getDynaClass(String tableName) {
        SqlDynaClass answer = (SqlDynaClass)((Object)this.dynaClassCache.get(tableName));
        if (answer == null) {
            Table table = this.getDatabase().findTable(tableName);
            if (table != null) {
                answer = this.createSqlDynaClass(table);
                this.dynaClassCache.put(tableName, answer);
            } else {
                log.warn((Object)("No such table: " + tableName));
                System.out.println("Couldn't find table: " + tableName);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(DynaBean dynaBean) throws SQLException {
        Connection connection = this.borrowConnection();
        try {
            if (this.exists(dynaBean, connection)) {
                this.update(dynaBean, connection);
            } else {
                this.insert(dynaBean, connection);
            }
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(DynaBean dynaBean) throws SQLException {
        Connection connection = this.borrowConnection();
        try {
            this.insert(dynaBean, connection);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DynaBean dynaBean) throws SQLException {
        Connection connection = this.borrowConnection();
        try {
            this.update(dynaBean, connection);
        }
        finally {
            this.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DynaBean dynaBean) throws SQLException {
        int size;
        SqlDynaProperty[] primaryKeys;
        SqlDynaClass dynaClass;
        PreparedStatement statement;
        Connection connection;
        block6: {
            connection = this.borrowConnection();
            statement = null;
            dynaClass = this.getSqlDynaClass(dynaBean);
            primaryKeys = dynaClass.getPrimaryKeyProperties();
            size = primaryKeys.length;
            if (size != 0) break block6;
            log.info((Object)("Cannot update type: " + (Object)((Object)dynaClass) + " as there are no primary keys to update"));
            this.closeStatement(statement);
            this.returnConnection(connection);
            return;
        }
        try {
            String sql = this.createDeleteSql(dynaClass, primaryKeys);
            if (log.isDebugEnabled()) {
                log.debug((Object)("About to execute SQL: " + sql));
            }
            statement = connection.prepareStatement(sql);
            for (int i = 0; i < size; ++i) {
                SqlDynaProperty primaryKey = primaryKeys[i];
                this.setObject(statement, 1 + i, dynaBean, primaryKey);
            }
            int count = statement.executeUpdate();
            if (count != 1) {
                log.warn((Object)("Attempted to delete a single row : " + dynaBean + " in table: " + dynaClass.getTableName() + " but changed: " + count + " row(s)"));
            }
            this.closeStatement(statement);
            this.returnConnection(connection);
        }
        catch (Throwable throwable) {
            this.closeStatement(statement);
            this.returnConnection(connection);
            throw throwable;
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
        this.dynaClassCache.clear();
    }

    protected boolean exists(DynaBean dynaBean, Connection connection) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(DynaBean dynaBean, Connection connection) throws SQLException {
        SqlDynaClass dynaClass = this.getSqlDynaClass(dynaBean);
        SqlDynaProperty[] properties = dynaClass.getSqlDynaProperties();
        int size = properties.length;
        if (size == 0) {
            log.info((Object)("Cannot insert type: " + (Object)((Object)dynaClass) + " as there are no properties"));
            return;
        }
        String sql = this.createInsertSql(dynaClass, properties);
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to execute SQL: " + sql));
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            for (int i = 0; i < size; ++i) {
                SqlDynaProperty property = properties[i];
                this.setObject(statement, 1 + i, dynaBean, property);
            }
            int count = statement.executeUpdate();
            if (count != 1) {
                log.warn((Object)("Attempted to insert a single row : " + dynaBean + " in table: " + dynaClass.getTableName() + " but changed: " + count + " row(s)"));
            }
        }
        finally {
            this.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(DynaBean dynaBean, Connection connection) throws SQLException {
        SqlDynaClass dynaClass = this.getSqlDynaClass(dynaBean);
        SqlDynaProperty[] primaryKeys = dynaClass.getPrimaryKeyProperties();
        if (primaryKeys.length == 0) {
            log.info((Object)("Cannot update type: " + (Object)((Object)dynaClass) + " as there are no primary keys to update"));
            return;
        }
        SqlDynaProperty[] properties = dynaClass.getNonPrimaryKeyProperties();
        String sql = this.createUpdateSql(dynaClass, primaryKeys, properties);
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to execute SQL: " + sql));
        }
        PreparedStatement statement = null;
        try {
            int i;
            statement = connection.prepareStatement(sql);
            int sqlIndex = 1;
            int size = properties.length;
            for (i = 0; i < size; ++i) {
                SqlDynaProperty property = properties[i];
                this.setObject(statement, sqlIndex++, dynaBean, property);
            }
            size = primaryKeys.length;
            for (i = 0; i < size; ++i) {
                SqlDynaProperty primaryKey = primaryKeys[i];
                this.setObject(statement, sqlIndex++, dynaBean, primaryKey);
            }
            int count = statement.executeUpdate();
            if (count != 1) {
                log.warn((Object)("Attempted to insert a single row : " + dynaBean + " in table: " + dynaClass.getTableName() + " but changed: " + count + " row(s)"));
            }
        }
        finally {
            this.closeStatement(statement);
        }
    }

    protected String createInsertSql(SqlDynaClass dynaClass, SqlDynaProperty[] properties) {
        int i;
        StringBuffer buffer = new StringBuffer("insert into ");
        buffer.append(dynaClass.getTableName());
        buffer.append(" (");
        int size = properties.length;
        for (i = 0; i < size; ++i) {
            SqlDynaProperty property = properties[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(property.getName());
        }
        buffer.append(") values (");
        if (size > 0) {
            buffer.append("?");
            for (i = 1; i < size; ++i) {
                buffer.append(", ?");
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected String createUpdateSql(SqlDynaClass dynaClass, SqlDynaProperty[] primaryKeys, SqlDynaProperty[] properties) {
        int i;
        StringBuffer buffer = new StringBuffer("update ");
        buffer.append(dynaClass.getTableName());
        buffer.append(" set ");
        for (i = 0; i < properties.length; ++i) {
            SqlDynaProperty property = properties[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(property.getName());
            buffer.append(" = ?");
        }
        buffer.append(" where ");
        int size = primaryKeys.length;
        for (i = 0; i < size; ++i) {
            SqlDynaProperty primaryKey = primaryKeys[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(primaryKey.getName());
            buffer.append(" = ?");
        }
        return buffer.toString();
    }

    protected String createDeleteSql(SqlDynaClass dynaClass, SqlDynaProperty[] primaryKeys) {
        StringBuffer buffer = new StringBuffer("delete ");
        buffer.append(dynaClass.getTableName());
        buffer.append(" where ");
        int size = primaryKeys.length;
        for (int i = 0; i < size; ++i) {
            SqlDynaProperty primaryKey = primaryKeys[i];
            if (i > 0) {
                buffer.append(" and ");
            }
            buffer.append(primaryKey.getName());
            buffer.append(" = ?");
        }
        return buffer.toString();
    }

    protected SqlDynaClass getSqlDynaClass(DynaBean dynaBean) {
        DynaClass dynaClass = dynaBean.getDynaClass();
        if (dynaClass instanceof SqlDynaClass) {
            return (SqlDynaClass)dynaClass;
        }
        throw new IllegalArgumentException("The dynaBean is not an instance of an SqlDynaClass");
    }

    protected SqlDynaClass createSqlDynaClass(Table table) {
        return SqlDynaClass.newInstance(table);
    }

    protected void setObject(PreparedStatement statement, int sqlIndex, DynaBean dynaBean, SqlDynaProperty property) throws SQLException {
        Object value = dynaBean.get(property.getName());
        if (value == null) {
            statement.setNull(sqlIndex, property.getColumn().getTypeCode());
        } else {
            statement.setObject(sqlIndex, value);
        }
    }

    protected Iterator createResultSetIterator(Connection connection, Statement statement, ResultSet resultSet) throws SQLException, IllegalAccessException, InstantiationException {
        ResultSetDynaClass resultSetClass = new ResultSetDynaClass(resultSet);
        return resultSetClass.iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

