/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.io;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.Database;
import org.apache.commons.sql.model.ForeignKey;
import org.apache.commons.sql.model.Index;
import org.apache.commons.sql.model.IndexColumn;
import org.apache.commons.sql.model.Reference;
import org.apache.commons.sql.model.Table;

public class JdbcModelReader {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$sql$io$JdbcModelReader == null ? (class$org$apache$commons$sql$io$JdbcModelReader = JdbcModelReader.class$("org.apache.commons.sql.io.JdbcModelReader")) : class$org$apache$commons$sql$io$JdbcModelReader));
    Connection connection = null;
    String catalog = null;
    String schema = null;
    String[] tableTypes = new String[]{"TABLE", "VIEW"};
    static /* synthetic */ Class class$org$apache$commons$sql$io$JdbcModelReader;

    public JdbcModelReader() {
    }

    public JdbcModelReader(Connection conn) {
        this.connection = conn;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTableTypes(String[] types) {
        this.tableTypes = types;
    }

    public Database getDatabase() throws SQLException {
        Database db = new Database();
        Iterator tableIterator = this.getTables().iterator();
        while (tableIterator.hasNext()) {
            db.addTable((Table)tableIterator.next());
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTables() throws SQLException {
        Vector<String> tableInfoColumns = new Vector<String>();
        DatabaseMetaData dbmd = this.connection.getMetaData();
        ResultSet tableData = null;
        Vector<Table> tables = new Vector<Table>();
        try {
            tableData = dbmd.getTables(this.catalog, this.schema, "%", this.tableTypes);
            ResultSetMetaData rsmd = tableData.getMetaData();
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                tableInfoColumns.add(rsmd.getColumnName(i + 1));
            }
            while (tableData.next()) {
                String tableCatalog = tableInfoColumns.contains("TABLE_CAT") ? tableData.getString("TABLE_CAT") : "";
                String tableSchema = tableInfoColumns.contains("TABLE_SCHEM") ? tableData.getString("TABLE_SCHEM") : "";
                String tableName = tableInfoColumns.contains("TABLE_NAME") ? tableData.getString("TABLE_NAME") : "";
                String tableType = tableInfoColumns.contains("TABLE_TYPE") ? tableData.getString("TABLE_TYPE") : "UNKNOWN";
                String tableRemarks = tableInfoColumns.contains("REMARKS") ? tableData.getString("REMARKS") : "";
                String tableTypeCatalog = tableInfoColumns.contains("TYPE_CAT") ? tableData.getString("TYPE_CAT") : null;
                String tableTypeSchema = tableInfoColumns.contains("TYPE_SCHEM") ? tableData.getString("TYPE_SCHEM") : null;
                String tableTypeName = tableInfoColumns.contains("TYPE_NAME") ? tableData.getString("TYPE_NAME") : null;
                String tableSelfRefColName = tableInfoColumns.contains("SELF_REFERENCING_COL_NAME") ? tableData.getString("SELF_REFERENCING_COL_NAME") : null;
                String tableRefGeneration = tableInfoColumns.contains("REF_GENERATION") ? tableData.getString("REF_GENERATION") : null;
                Table t1 = new Table();
                t1.setName(tableName);
                tables.add(t1);
            }
            if (tableData != null) {
                tableData.close();
            }
            Iterator i = tables.iterator();
            while (i.hasNext()) {
                Table t = (Table)i.next();
                Iterator columnIterator = this.getColumnsForTable(t.getName()).iterator();
                while (columnIterator.hasNext()) {
                    t.addColumn((Column)columnIterator.next());
                }
                Iterator fkIterator = this.getForeignKeysForTable(t.getName()).iterator();
                while (fkIterator.hasNext()) {
                    t.addForeignKey((ForeignKey)fkIterator.next());
                }
                Iterator idxIterator = this.getIndexesForTable(t.getName()).iterator();
                while (idxIterator.hasNext()) {
                    t.addIndex((Index)idxIterator.next());
                }
            }
            Vector<Table> vector = tables;
            return vector;
        }
        finally {
            if (tableData != null) {
                tableData.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getColumnsForTable(String tableName) throws SQLException {
        Vector<String> columnInfoColumns = new Vector<String>();
        DatabaseMetaData dbmd = this.connection.getMetaData();
        Vector<Column> columns = new Vector<Column>();
        ResultSet columnData = null;
        List primaryKeys = this.getPrimaryKeysForTable(tableName);
        try {
            columnData = dbmd.getColumns(this.catalog, this.schema, tableName, null);
            ResultSetMetaData rsmd = columnData.getMetaData();
            for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                columnInfoColumns.add(rsmd.getColumnName(i + 1));
            }
            while (columnData.next()) {
                String columnTableCatalog = columnInfoColumns.contains("TABLE_CAT") ? columnData.getString("TABLE_CAT") : "";
                String columnTableSchema = columnInfoColumns.contains("TABLE_SCHEM") ? columnData.getString("TABLE_SCHEM") : "";
                String columnName = columnInfoColumns.contains("COLUMN_NAME") ? columnData.getString("COLUMN_NAME") : "UNKNOWN";
                int columnType = columnInfoColumns.contains("DATA_TYPE") ? columnData.getInt("DATA_TYPE") : 1111;
                String columnDbName = columnInfoColumns.contains("TYPE_NAME") ? columnData.getString("TYPE_NAME") : null;
                int columnSize = columnInfoColumns.contains("COLUMN_SIZE") ? columnData.getInt("COLUMN_SIZE") : 0;
                int columnDecimalDigits = columnInfoColumns.contains("DECIMAL_DIGITS") ? columnData.getInt("DECIMAL_DIGITS") : 0;
                int columnRadix = columnInfoColumns.contains("NUM_PREC_RADIX") ? columnData.getInt("NUM_PREC_RADIX") : 10;
                int columnNullable = columnInfoColumns.contains("NULLABLE") ? columnData.getInt("NULLABLE") : 2;
                String columnRemarks = columnInfoColumns.contains("REMARKS") ? columnData.getString("REMARKS") : "";
                String columnDefaultValue = columnInfoColumns.contains("COLUMN_DEF") ? columnData.getString("COLUMN_DEF") : null;
                int columnCharOctetLength = columnInfoColumns.contains("CHAR_OCTET_LENGTH") ? columnData.getInt("CHAR_OCTET_LENGTH") : 0;
                int columnOrdinalPosition = columnInfoColumns.contains("ORDINAL_POSITION") ? columnData.getInt("ORDINAL_POSITION") : 0;
                boolean columnIsNullable = false;
                columnIsNullable = !columnInfoColumns.contains("IS_NULLABLE") || !"NO".equalsIgnoreCase(columnData.getString("IS_NULLABLE"));
                String columnScopeCatalog = columnInfoColumns.contains("SCOPE_CATLOG") ? columnData.getString("SCOPE_CATLOG") : null;
                String columnScopeSchema = columnInfoColumns.contains("SCOPE_SCHEMA") ? columnData.getString("SCOPE_SCHEMA") : null;
                String columnScopeTable = columnInfoColumns.contains("SCOPE_TABLE") ? columnData.getString("SCOPE_TABLE") : null;
                short columnSourceDataType = columnInfoColumns.contains("SOURCE_DATA_TYPE") ? columnData.getShort("SOURCE_DATA_TYPE") : (short)0;
                Column col = new Column();
                col.setName(columnName);
                col.setTypeCode(columnType);
                col.setSize(columnSize);
                col.setRequired(!columnIsNullable);
                col.setDefaultValue(columnDefaultValue);
                if (primaryKeys.contains(col.getName())) {
                    col.setPrimaryKey(true);
                } else {
                    col.setPrimaryKey(false);
                }
                col.setPrecisionRadix(columnRadix);
                col.setScale(columnDecimalDigits);
                columns.add(col);
            }
            Vector<Column> vector = columns;
            return vector;
        }
        finally {
            if (columnData != null) {
                columnData.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPrimaryKeysForTable(String tableName) throws SQLException {
        DatabaseMetaData dbmd = this.connection.getMetaData();
        Vector<String> pk = new Vector<String>();
        ResultSet parts = null;
        try {
            parts = dbmd.getPrimaryKeys(this.catalog, this.schema, tableName);
        }
        catch (SQLException e) {
            log.trace((Object)"database does not support getPrimaryKeys()", (Throwable)e);
        }
        if (parts != null) {
            try {
                while (parts.next()) {
                    pk.add(parts.getString(4));
                }
            }
            finally {
                if (parts != null) {
                    parts.close();
                }
            }
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getForeignKeysForTable(String tableName) throws SQLException {
        DatabaseMetaData dbmd = this.connection.getMetaData();
        Vector<ForeignKey> fks = new Vector<ForeignKey>();
        ResultSet foreignKeys = null;
        String prevPkTable = null;
        ForeignKey currFk = null;
        try {
            foreignKeys = dbmd.getImportedKeys(this.catalog, this.schema, tableName);
        }
        catch (SQLException e) {
            log.trace((Object)"database does not support getImportedKeys()", (Throwable)e);
        }
        if (foreignKeys != null) {
            try {
                while (foreignKeys.next()) {
                    String pkCat = foreignKeys.getString("PKTABLE_CAT");
                    String pkSchema = foreignKeys.getString("PKTABLE_SCHEM");
                    String pkTable = foreignKeys.getString("PKTABLE_NAME");
                    String pkColumn = foreignKeys.getString("PKCOLUMN_NAME");
                    String fkCat = foreignKeys.getString("FKTABLE_CAT");
                    String fkSchema = foreignKeys.getString("FKTABLE_SCHEM");
                    String fkTable = foreignKeys.getString("FKTABLE_NAME");
                    String fkColumn = foreignKeys.getString("FKCOLUMN_NAME");
                    short keySequence = foreignKeys.getShort("KEY_SEQ");
                    short updateRule = foreignKeys.getShort("UPDATE_RULE");
                    short deleteRule = foreignKeys.getShort("DELETE_RULE");
                    String fkName = foreignKeys.getString("FK_NAME");
                    String pkName = foreignKeys.getString("PK_NAME");
                    short deferrablity = foreignKeys.getShort("DEFERRABILITY");
                    if (!pkTable.equals(prevPkTable)) {
                        if (currFk != null) {
                            fks.add(currFk);
                        }
                        currFk = new ForeignKey();
                        currFk.setForeignTable(pkTable);
                        prevPkTable = pkTable;
                    }
                    Reference ref = new Reference();
                    ref.setForeign(pkColumn);
                    ref.setLocal(fkColumn);
                    currFk.addReference(ref);
                }
                if (currFk != null) {
                    fks.add(currFk);
                    currFk = null;
                }
            }
            finally {
                if (foreignKeys != null) {
                    foreignKeys.close();
                }
            }
        }
        return fks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getIndexesForTable(String tableName) throws SQLException {
        DatabaseMetaData dbmd = this.connection.getMetaData();
        HashMap<String, Index> indexesByName = new HashMap<String, Index>();
        ResultSet columnData = null;
        try {
            columnData = dbmd.getIndexInfo(this.catalog, this.schema, tableName, false, false);
        }
        catch (SQLException e) {
            log.trace((Object)"database does not support getIndexInfo()", (Throwable)e);
        }
        if (columnData != null) {
            try {
                while (columnData.next()) {
                    String indexName = columnData.getString("INDEX_NAME");
                    boolean unique = !columnData.getBoolean("NON_UNIQUE");
                    String column = columnData.getString("COLUMN_NAME");
                    Index index = (Index)indexesByName.get(indexName);
                    if (index == null) {
                        index = new Index();
                        index.setName(indexName);
                        indexesByName.put(indexName, index);
                        index.setUnique(unique);
                    }
                    IndexColumn ic = new IndexColumn();
                    ic.setName(column);
                    index.addIndexColumn(ic);
                }
            }
            finally {
                if (columnData != null) {
                    columnData.close();
                }
            }
        }
        return new Vector(indexesByName.values());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

