/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.model;

import org.apache.commons.sql.model.TypeMap;

public class Column {
    private String name;
    private boolean primaryKey = false;
    private boolean required = false;
    private boolean autoIncrement = false;
    private int typeCode;
    private String type;
    private int size = 0;
    private String defaultValue = null;
    private int scale = 0;
    private int precisionRadix = 10;
    private int ordinalPosition = 0;

    public Column() {
    }

    public Column(String name, int typeCode, int size, boolean required, boolean primaryKey, boolean autoIncrement, String defaultValue) {
        this.name = name;
        this.typeCode = typeCode;
        this.type = TypeMap.getJdbcTypeName(typeCode);
        this.size = size;
        this.required = required;
        this.primaryKey = primaryKey;
        this.autoIncrement = autoIncrement;
        this.defaultValue = defaultValue;
    }

    public Column(String name, String type, int size, boolean required, boolean primaryKey, boolean autoIncrement, String defaultValue) {
        this(name, TypeMap.getJdbcTypeCode(type), size, required, primaryKey, autoIncrement, defaultValue);
    }

    public Column(String name, int typeCode, int size, boolean required, boolean primaryKey, boolean autoIncrement, String defaultValue, int scale) {
        this.name = name;
        this.typeCode = typeCode;
        this.type = TypeMap.getJdbcTypeName(typeCode);
        this.size = size;
        this.required = required;
        this.primaryKey = primaryKey;
        this.autoIncrement = autoIncrement;
        this.defaultValue = defaultValue;
        this.scale = scale;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ";type=" + this.type + "]";
    }

    public String toStringAll() {
        return "Column[name=" + this.name + ";type=" + this.type + ";typeCode=" + this.typeCode + ";size=" + this.size + ";required=" + this.required + ";pk=" + this.primaryKey + ";auto=" + this.autoIncrement + ";default=" + this.defaultValue + ";scale=" + this.scale + ";prec=" + this.precisionRadix + ";ord=" + this.ordinalPosition + "]";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(int typeCode) {
        this.typeCode = typeCode;
        this.type = TypeMap.getJdbcTypeName(typeCode);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.typeCode = TypeMap.getJdbcTypeCode(type);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getPrecisionRadix() {
        return this.precisionRadix;
    }

    public void setPrecisionRadix(int precisionRadix) {
        this.precisionRadix = precisionRadix;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }
}

