/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.model.ForeignKey;
import org.apache.commons.sql.model.Index;
import org.apache.commons.sql.model.Unique;

public class Table {
    private static final Predicate UNIQUE_PREDICATE = new Predicate(){

        public boolean evaluate(Object input) {
            return ((Index)input).isUnique();
        }
    };
    private String catalog = null;
    private String name = null;
    private String schema = null;
    private String remarks = null;
    private String type = null;
    private List columns = new ArrayList();
    private List foreignKeys = new ArrayList();
    private List indexes = new ArrayList();

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getType() {
        return this.type == null ? "(null)" : this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void addAll(List columns) {
        if (columns != null && columns.size() > 0) {
            int columnsSize = columns.size();
            for (int i = 0; i < columnsSize; ++i) {
                Column column = (Column)columns.get(i);
                if (column == null) continue;
                this.addColumn(column);
            }
        }
    }

    public List getColumns() {
        return this.columns;
    }

    public void addForeignKey(ForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    public List getForeignKeys() {
        return this.foreignKeys;
    }

    public Column getColumn(int index) {
        return (Column)this.columns.get(index);
    }

    public ForeignKey getForeignKey(int index) {
        return (ForeignKey)this.foreignKeys.get(index);
    }

    public void addIndex(Index index) {
        this.indexes.add(index);
    }

    public List getIndexes() {
        return this.indexes;
    }

    public Index getIndex(int index) {
        return (Index)this.indexes.get(index);
    }

    public void addUnique(Unique index) {
        this.addIndex(index);
    }

    public Iterator getUniques() {
        return new FilterIterator(this.indexes.iterator(), UNIQUE_PREDICATE);
    }

    public boolean hasPrimaryKey() {
        Iterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!column.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public Column findColumn(String name) {
        Iterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return column;
        }
        return null;
    }

    public Index findIndex(String name) {
        Iterator iter = this.getIndexes().iterator();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            if (!index.getName().equalsIgnoreCase(name)) continue;
            return index;
        }
        return null;
    }

    public List getPrimaryKeyColumns() {
        ArrayList<Column> answer = new ArrayList<Column>();
        Iterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!column.isPrimaryKey()) continue;
            answer.add(column);
        }
        return answer;
    }

    public Column getAutoIncrementColumn() {
        Iterator iter = this.getColumns().iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!column.isAutoIncrement()) continue;
            return column;
        }
        return null;
    }
}

