/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.model;

import java.util.Hashtable;

public class TypeMap {
    public static final String CHAR = "CHAR";
    public static final String VARCHAR = "VARCHAR";
    public static final String LONGVARCHAR = "LONGVARCHAR";
    public static final String CLOB = "CLOB";
    public static final String NUMERIC = "NUMERIC";
    public static final String DECIMAL = "DECIMAL";
    public static final String BIT = "BIT";
    public static final String TINYINT = "TINYINT";
    public static final String SMALLINT = "SMALLINT";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String REAL = "REAL";
    public static final String FLOAT = "FLOAT";
    public static final String DOUBLE = "DOUBLE";
    public static final String BINARY = "BINARY";
    public static final String VARBINARY = "VARBINARY";
    public static final String LONGVARBINARY = "LONGVARBINARY";
    public static final String BLOB = "BLOB";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String BOOLEANCHAR = "BOOLEANCHAR";
    public static final String BOOLEANINT = "BOOLEANINT";
    private static final String[] TEXT_TYPES = new String[]{"CHAR", "VARCHAR", "LONGVARCHAR", "CLOB", "DATE", "TIME", "TIMESTAMP", "BOOLEANCHAR"};
    private static final String[] DECIMAL_TYPES = new String[]{"NUMERIC", "DECIMAL", "REAL", "FLOAT", "DOUBLE"};
    private static Hashtable sqlTypeNameToTypeID = new Hashtable();
    private static Hashtable typeIdToSqlTypeName = new Hashtable();

    public static int getJdbcTypeCode(String typeName) {
        Integer answer = (Integer)sqlTypeNameToTypeID.get(typeName.toUpperCase());
        if (answer != null) {
            return answer;
        }
        return 1111;
    }

    public static String getJdbcTypeName(int typeCode) {
        String answer = (String)typeIdToSqlTypeName.get(new Integer(typeCode));
        if (answer == null) {
            System.out.println("Couldn't find JDBC Name for typeCode: " + typeCode);
            answer = "UNKNOWN";
        }
        return answer;
    }

    public static final boolean isTextType(int type) {
        return TypeMap.isTextType(TypeMap.getJdbcTypeName(type));
    }

    public static final boolean isTextType(String type) {
        for (int i = 0; i < TEXT_TYPES.length; ++i) {
            if (!type.equalsIgnoreCase(TEXT_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    public static final boolean isDecimalType(int type) {
        return TypeMap.isDecimalType(TypeMap.getJdbcTypeName(type));
    }

    public static final boolean isDecimalType(String type) {
        for (int i = 0; i < DECIMAL_TYPES.length; ++i) {
            if (!type.equalsIgnoreCase(DECIMAL_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    protected static void registerSqlTypeID(Integer sqlTypeID, String name) {
        sqlTypeNameToTypeID.put(name, sqlTypeID);
        typeIdToSqlTypeName.put(sqlTypeID, name);
    }

    static {
        TypeMap.registerSqlTypeID(new Integer(1), CHAR);
        TypeMap.registerSqlTypeID(new Integer(12), VARCHAR);
        TypeMap.registerSqlTypeID(new Integer(-1), LONGVARCHAR);
        TypeMap.registerSqlTypeID(new Integer(2005), CLOB);
        TypeMap.registerSqlTypeID(new Integer(2), NUMERIC);
        TypeMap.registerSqlTypeID(new Integer(3), DECIMAL);
        TypeMap.registerSqlTypeID(new Integer(-7), BIT);
        TypeMap.registerSqlTypeID(new Integer(-6), TINYINT);
        TypeMap.registerSqlTypeID(new Integer(5), SMALLINT);
        TypeMap.registerSqlTypeID(new Integer(4), INTEGER);
        TypeMap.registerSqlTypeID(new Integer(-5), BIGINT);
        TypeMap.registerSqlTypeID(new Integer(7), REAL);
        TypeMap.registerSqlTypeID(new Integer(6), FLOAT);
        TypeMap.registerSqlTypeID(new Integer(8), DOUBLE);
        TypeMap.registerSqlTypeID(new Integer(-2), BINARY);
        TypeMap.registerSqlTypeID(new Integer(-3), VARBINARY);
        TypeMap.registerSqlTypeID(new Integer(-4), LONGVARBINARY);
        TypeMap.registerSqlTypeID(new Integer(2004), BLOB);
        TypeMap.registerSqlTypeID(new Integer(91), DATE);
        TypeMap.registerSqlTypeID(new Integer(92), TIME);
        TypeMap.registerSqlTypeID(new Integer(93), TIMESTAMP);
    }
}

