/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.task;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.commons.sql.builder.SqlBuilder;
import org.apache.commons.sql.builder.SqlBuilderFactory;
import org.apache.commons.sql.io.DatabaseReader;
import org.apache.commons.sql.model.Database;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DDLTask
extends Task {
    private File xmlFile;
    private File output;
    private String targetDatabase;
    private boolean dropTables = true;

    public File getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    public void setTargetDatabase(String targetDatabase) {
        this.targetDatabase = targetDatabase;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public boolean isDropTables() {
        return this.dropTables;
    }

    public void setDropTables(boolean dropTables) {
        this.dropTables = dropTables;
    }

    public void execute() throws BuildException {
        if (this.targetDatabase == null) {
            throw new BuildException("Must specify a targetDatabase attribute");
        }
        if (this.xmlFile == null) {
            throw new BuildException("Must specify an xmlFile attribute");
        }
        if (this.output == null) {
            throw new BuildException("Must specify an output attribute");
        }
        Database database = null;
        try {
            database = this.loadDatabase();
        }
        catch (Exception e) {
            throw new BuildException("Failed to parse file: " + this.getXmlFile(), (Throwable)e);
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.getOutput());
        }
        catch (Exception e) {
            throw new BuildException("Failed to create file: " + this.getOutput(), (Throwable)e);
        }
        SqlBuilder builder = null;
        try {
            builder = this.newSqlBuilder(writer);
        }
        catch (Exception e) {
            throw new BuildException("Failed to create SqlBuilder for database: " + this.getTargetDatabase(), (Throwable)e);
        }
        if (builder == null) {
            throw new BuildException("Unknown database type: " + this.getTargetDatabase());
        }
        try {
            builder.createDatabase(database, this.dropTables);
            writer.close();
        }
        catch (Exception e) {
            throw new BuildException("Error occurred while writing to file: " + this.getOutput(), (Throwable)e);
        }
    }

    protected Database loadDatabase() throws Exception {
        DatabaseReader reader = new DatabaseReader();
        return (Database)reader.parse(this.getXmlFile());
    }

    protected SqlBuilder newSqlBuilder(Writer writer) throws Exception {
        SqlBuilder builder = SqlBuilderFactory.newSqlBuilder(this.getTargetDatabase());
        builder.setWriter(writer);
        return builder;
    }
}

