/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.task;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.sql.io.JdbcModelReader;
import org.apache.commons.sql.model.Database;
import org.apache.commons.sql.util.DataSourceWrapper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class DatabaseTask
extends Task {
    protected String dbUrl;
    protected String dbDriver;
    protected String dbUser;
    protected String dbPassword;
    protected String dbCatalog;
    protected String dbSchema;

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbCatalog(String dbCatalog) {
        this.dbCatalog = dbCatalog;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setDbUrl(String v) {
        this.dbUrl = v;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbDriver(String v) {
        this.dbDriver = v;
    }

    public void setDbUser(String v) {
        this.dbUser = v;
    }

    public void setDbPassword(String v) {
        this.dbPassword = v;
    }

    protected void printDbSettings() throws BuildException {
        System.err.println("Your DB settings are:");
        System.err.println("driver : " + this.dbDriver);
        System.err.println("URL : " + this.dbUrl);
        System.err.println("user : " + this.dbUser);
        System.err.println("password : " + this.dbPassword);
        System.err.println("catalog : " + this.dbCatalog);
        System.err.println("schema : " + this.dbSchema);
    }

    protected DataSource getDataSource() throws ClassNotFoundException, SQLException {
        DataSourceWrapper wrapper = new DataSourceWrapper(this.dbDriver, this.dbUrl, this.dbUser, this.dbPassword);
        return wrapper;
    }

    protected Database getDbFromConnection(Connection con) throws SQLException {
        JdbcModelReader reader = new JdbcModelReader(con);
        if (this.dbCatalog != null) {
            reader.setCatalog(this.dbCatalog);
        }
        if (this.dbSchema != null) {
            reader.setSchema(this.dbSchema);
        }
        Database db = reader.getDatabase();
        return db;
    }
}

