/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.task;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JDBCTransformTask
extends Task {
    protected String xmlSchema;
    protected String dbUrl;
    protected String dbDriver;
    protected String dbUser;
    protected String dbPassword;
    protected String dbSchema;
    protected DocumentImpl doc;
    protected Node database;
    protected Node appData;
    protected Hashtable primaryKeys;
    protected Hashtable columnTableMap;
    protected boolean sameJavaName;
    XMLSerializer xmlSerializer;

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setDbUrl(String v) {
        this.dbUrl = v;
    }

    public void setDbDriver(String v) {
        this.dbDriver = v;
    }

    public void setDbUser(String v) {
        this.dbUser = v;
    }

    public void setDbPassword(String v) {
        this.dbPassword = v;
    }

    public void setOutputFile(String v) {
        this.xmlSchema = v;
    }

    public void setSameJavaName(boolean v) {
        this.sameJavaName = v;
    }

    public boolean isSameJavaName() {
        return this.sameJavaName;
    }

    public void execute() throws BuildException {
        System.err.println("Torque - JDBCToXMLSchema starting\n");
        System.err.println("Your DB settings are:");
        System.err.println("driver : " + this.dbDriver);
        System.err.println("URL : " + this.dbUrl);
        System.err.println("user : " + this.dbUser);
        System.err.println("password : " + this.dbPassword);
        System.err.println("schema : " + this.dbSchema);
        DocumentTypeImpl docType = new DocumentTypeImpl(null, "app-data", null, "http://jakarta.apache.org/turbine/dtd/database.dtd");
        this.doc = new DocumentImpl((DocumentType)docType);
        this.doc.appendChild((Node)this.doc.createComment(" Autogenerated by JDBCToXMLSchema! "));
        try {
            this.generateXML();
            this.xmlSerializer = new XMLSerializer((Writer)new PrintWriter(new FileOutputStream(this.xmlSchema)), new OutputFormat("xml", null, true));
            this.xmlSerializer.serialize((Document)this.doc);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        System.err.println("\nTorque - JDBCToXMLSchema finished");
    }

    public void generateXML() throws Exception {
        String curTable;
        int i;
        Class.forName(this.dbDriver);
        System.err.println("DB driver sucessfuly instantiated");
        Connection con = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
        System.err.println("DB connection established");
        DatabaseMetaData dbMetaData = con.getMetaData();
        List tableList = this.getTableNames(dbMetaData);
        this.appData = this.doc.createElement("app-data");
        this.database = this.doc.createElement("database");
        this.columnTableMap = new Hashtable();
        this.log("Building column/table map...");
        for (i = 0; i < tableList.size(); ++i) {
            curTable = (String)tableList.get(i);
            List columns = this.getColumns(dbMetaData, curTable);
            for (int j = 0; j < columns.size(); ++j) {
                List col = (List)columns.get(j);
                String name = (String)col.get(0);
                this.columnTableMap.put(name, curTable);
            }
        }
        for (i = 0; i < tableList.size(); ++i) {
            curTable = (String)tableList.get(i);
            this.log("Processing table: " + curTable);
            Element table = this.doc.createElement("table");
            table.setAttribute("name", curTable);
            if (this.isSameJavaName()) {
                table.setAttribute("javaName", curTable);
            }
            List columns = this.getColumns(dbMetaData, curTable);
            List primKeys = this.getPrimaryKeys(dbMetaData, curTable);
            Collection forgnKeys = this.getForeignKeys(dbMetaData, curTable);
            this.primaryKeys = new Hashtable();
            for (int k = 0; k < primKeys.size(); ++k) {
                String curPrimaryKey = (String)primKeys.get(k);
                this.primaryKeys.put(curPrimaryKey, curPrimaryKey);
            }
            for (int j = 0; j < columns.size(); ++j) {
                List col = (List)columns.get(j);
                String name = (String)col.get(0);
                Integer type = (Integer)col.get(1);
                int size = (Integer)col.get(2);
                Integer nullType = (Integer)col.get(3);
                String defValue = (String)col.get(4);
                Element column = this.doc.createElement("column");
                column.setAttribute("name", name);
                if (this.isSameJavaName()) {
                    column.setAttribute("javaName", name);
                }
                if (size > 0 && (type == 1 || type == 12 || type == -1)) {
                    column.setAttribute("size", new Integer(size).toString());
                }
                if (nullType == 0) {
                    column.setAttribute("required", "true");
                }
                if (this.primaryKeys.containsKey(name)) {
                    column.setAttribute("primaryKey", "true");
                }
                if (defValue != null) {
                    if (defValue.startsWith("(") && defValue.endsWith(")")) {
                        defValue = defValue.substring(1, defValue.length() - 1);
                    }
                    if (defValue.startsWith("'") && defValue.endsWith("'")) {
                        defValue = defValue.substring(1, defValue.length() - 1);
                    }
                    column.setAttribute("default", defValue);
                }
                table.appendChild(column);
            }
            Iterator l = forgnKeys.iterator();
            while (l.hasNext()) {
                Object[] forKey = (Object[])l.next();
                String foreignKeyTable = (String)forKey[0];
                List refs = (List)forKey[1];
                Element fk = this.doc.createElement("foreign-key");
                fk.setAttribute("foreignTable", foreignKeyTable);
                for (int m = 0; m < refs.size(); ++m) {
                    Element ref = this.doc.createElement("reference");
                    String[] refData = (String[])refs.get(m);
                    ref.setAttribute("local", refData[0]);
                    ref.setAttribute("foreign", refData[1]);
                    fk.appendChild(ref);
                }
                table.appendChild(fk);
            }
            this.database.appendChild(table);
        }
        this.appData.appendChild(this.database);
        this.doc.appendChild(this.appData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableNames(DatabaseMetaData dbMeta) throws SQLException {
        this.log("Getting table list...");
        Vector<String> tables = new Vector<String>();
        ResultSet tableNames = null;
        String[] types = new String[]{"TABLE", "VIEW"};
        try {
            tableNames = dbMeta.getTables(null, this.dbSchema, "%", types);
            while (tableNames.next()) {
                String name = tableNames.getString(3);
                String type = tableNames.getString(4);
                tables.add(name);
            }
        }
        finally {
            if (tableNames != null) {
                tableNames.close();
            }
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getColumns(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        Vector columns = new Vector();
        ResultSet columnSet = null;
        try {
            columnSet = dbMeta.getColumns(null, this.dbSchema, tableName, null);
            while (columnSet.next()) {
                String name = columnSet.getString(4);
                Integer sqlType = new Integer(columnSet.getString(5));
                Integer size = new Integer(columnSet.getInt(7));
                Integer nullType = new Integer(columnSet.getInt(11));
                String defValue = columnSet.getString(13);
                Vector<Object> col = new Vector<Object>(5);
                col.add(name);
                col.add(sqlType);
                col.add(size);
                col.add(nullType);
                col.add(defValue);
                columns.add(col);
            }
        }
        finally {
            if (columnSet != null) {
                columnSet.close();
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPrimaryKeys(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        Vector<String> pk = new Vector<String>();
        ResultSet parts = null;
        try {
            parts = dbMeta.getPrimaryKeys(null, this.dbSchema, tableName);
            while (parts.next()) {
                pk.add(parts.getString(4));
            }
        }
        finally {
            if (parts != null) {
                parts.close();
            }
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getForeignKeys(DatabaseMetaData dbMeta, String tableName) throws SQLException {
        Hashtable<String, Object[]> fks = new Hashtable<String, Object[]>();
        ResultSet foreignKeys = null;
        try {
            foreignKeys = dbMeta.getImportedKeys(null, this.dbSchema, tableName);
            while (foreignKeys.next()) {
                Vector<String[]> refs;
                Object[] fk;
                String fkName = foreignKeys.getString(12);
                if (fkName == null) {
                    fkName = foreignKeys.getString(3);
                }
                if ((fk = (Object[])fks.get(fkName)) == null) {
                    fk = new Object[]{foreignKeys.getString(3), refs = new Vector<String[]>()};
                    fks.put(fkName, fk);
                } else {
                    refs = (Vector<String[]>)fk[1];
                }
                String[] ref = new String[]{foreignKeys.getString(8), foreignKeys.getString(4)};
                refs.add(ref);
            }
        }
        finally {
            if (foreignKeys != null) {
                foreignKeys.close();
            }
        }
        return fks.values();
    }
}

