/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.task;

import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Hashtable;
import org.apache.commons.sql.io.DatabaseWriter;
import org.apache.commons.sql.io.JdbcModelReader;
import org.apache.commons.sql.model.Database;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JdbcToSchemaTask
extends Task {
    protected String outputFile;
    protected String dbUrl;
    protected String dbDriver;
    protected String dbUser;
    protected String dbPassword;
    protected String dbCatalog;
    protected String dbSchema;
    protected Hashtable primaryKeys;
    protected Hashtable columnTableMap;
    protected boolean useTypeNames = false;

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbCatalog(String dbCatalog) {
        this.dbCatalog = dbCatalog;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setDbUrl(String v) {
        this.dbUrl = v;
    }

    public void setDbDriver(String v) {
        this.dbDriver = v;
    }

    public void setDbUser(String v) {
        this.dbUser = v;
    }

    public void setDbPassword(String v) {
        this.dbPassword = v;
    }

    public void setOutputFile(String v) {
        this.outputFile = v;
    }

    public void setUseTypeNames(boolean b) {
        this.useTypeNames = b;
    }

    public void execute() throws BuildException {
        System.err.println("Commons-Sql JdbcToSchema starting\n");
        System.err.println("Your DB settings are:");
        System.err.println("driver : " + this.dbDriver);
        System.err.println("URL : " + this.dbUrl);
        System.err.println("user : " + this.dbUser);
        System.err.println("password : " + this.dbPassword);
        System.err.println("schema : " + this.dbSchema);
        Database db = null;
        try {
            db = this.getDbFromJdbc();
            DatabaseWriter w = new DatabaseWriter(new FileWriter(this.outputFile));
            w.write(db);
            w.close();
        }
        catch (Exception e) {
            System.out.println("exception during load:" + e.getMessage());
        }
    }

    public Database getDbFromJdbc() throws Exception {
        Class.forName(this.dbDriver);
        System.err.println("DB driver sucessfuly instantiated");
        Connection con = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
        System.err.println("DB connection established");
        JdbcModelReader reader = new JdbcModelReader(con);
        if (this.dbCatalog != null) {
            reader.setCatalog(this.dbCatalog);
        }
        if (this.dbSchema != null) {
            reader.setSchema(this.dbSchema);
        }
        Database db = reader.getDatabase();
        return db;
    }
}

