/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.type;

import org.apache.commons.sql.model.Column;

public class Mapping {
    public static final String SIZE_FORMAT = "size";
    public static final String SIZE_SCALE_FORMAT = "size-scale";
    private String name;
    private String sqlName;
    private String format;

    public Mapping() {
    }

    public Mapping(String name, String sqlName, String format) {
        this.name = name;
        this.sqlName = sqlName;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSQLName() {
        return this.sqlName;
    }

    public void setSQLName(String name) {
        this.sqlName = name;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getSQLType(Column column) {
        StringBuffer result = new StringBuffer(this.sqlName);
        int size = column.getSize();
        int scale = column.getScale();
        if (SIZE_FORMAT.equals(this.format)) {
            if (size > 1) {
                result.append("(");
                result.append(size);
                result.append(")");
            }
        } else if (SIZE_SCALE_FORMAT.equals(this.format)) {
            if (size > 0) {
                result.append("(");
                result.append(size);
                if (scale != 0) {
                    result.append(", ");
                    result.append(scale);
                }
                result.append(")");
            }
        } else if (this.format != null) {
            result.append(this.format);
        }
        return result.toString();
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ";SQLName=" + this.sqlName + ";format=" + this.format + "]";
    }
}

