/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.type;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

class TypeMap
extends org.apache.commons.sql.model.TypeMap {
    public static final String[] VARCHARS = new String[]{"VARCHAR", "LONGVARCHAR"};
    public static final String[] EXACT_NUMERICS = new String[]{"TINYINT", "SMALLINT", "INTEGER", "BIGINT", "NUMERIC", "DECIMAL"};
    public static final String[] APPROX_NUMERICS = new String[]{"REAL", "FLOAT", "DOUBLE"};
    private static final HashMap TYPE_MAP = new HashMap();
    private static final HashMap NAME_MAP = new HashMap();
    static /* synthetic */ Class class$java$sql$Types;

    TypeMap() {
    }

    public static Integer getType(String name) {
        return (Integer)NAME_MAP.get(name);
    }

    public static String getName(int type) {
        return (String)TYPE_MAP.get(new Integer(type));
    }

    public static boolean isVarChar(String name) {
        return TypeMap.isType(name, VARCHARS);
    }

    public static boolean isExactNumeric(String name) {
        return TypeMap.isType(name, EXACT_NUMERICS);
    }

    public static boolean isApproxNumeric(String name) {
        return TypeMap.isType(name, APPROX_NUMERICS);
    }

    private static boolean isType(String name, String[] types) {
        boolean result = false;
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Field[] fields = (class$java$sql$Types == null ? (class$java$sql$Types = TypeMap.class$("java.sql.Types")) : class$java$sql$Types).getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers())) continue;
                Integer type = (Integer)field.get(null);
                String name = field.getName().toUpperCase();
                NAME_MAP.put(name, type);
                TYPE_MAP.put(type, name);
            }
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }
}

