/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.sql.model.Column;
import org.apache.commons.sql.type.Mapping;
import org.apache.commons.sql.type.Type;
import org.apache.commons.sql.type.TypeMap;
import org.apache.commons.sql.type.TypeMapping;

public class Types {
    private SequencedHashMap types = new SequencedHashMap();
    private List mappingList = new ArrayList();
    private HashMap mappings = new HashMap();
    private List autoIncList = new ArrayList();
    private HashMap autoIncMappings = new HashMap();
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$sql$type$Types == null ? (class$org$apache$commons$sql$type$Types = Types.class$("org.apache.commons.sql.type.Types")) : class$org$apache$commons$sql$type$Types));
    static /* synthetic */ Class class$org$apache$commons$sql$type$Types;

    public List getTypes() {
        return new ArrayList(this.types.values());
    }

    public Type getType(String sqlName) {
        return (Type)this.types.get((Object)sqlName);
    }

    public void addType(Type type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding type: " + type));
        }
        this.types.put((Object)type.getSQLName(), (Object)type);
    }

    public List getMappings() {
        return this.mappingList;
    }

    public void addMapping(Mapping mapping) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding mapping: " + mapping));
        }
        if (this.getType(mapping.getSQLName()) == null) {
            throw new IllegalArgumentException("No type registered for mapping: " + mapping);
        }
        this.mappingList.add(mapping);
        ArrayList<Mapping> list = (ArrayList<Mapping>)this.mappings.get(mapping.getName());
        if (list == null) {
            list = new ArrayList<Mapping>();
            this.mappings.put(mapping.getName(), list);
        }
        list.add(mapping);
    }

    public List getAutoIncrementMappings() {
        return this.autoIncList;
    }

    public void addAutoIncrementMapping(Mapping mapping) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding auto-increment mapping: " + mapping));
        }
        if (this.getType(mapping.getSQLName()) == null) {
            throw new IllegalArgumentException("No type registered for mapping: " + mapping);
        }
        this.autoIncList.add(mapping);
        ArrayList<Mapping> list = (ArrayList<Mapping>)this.autoIncMappings.get(mapping.getName());
        if (list == null) {
            list = new ArrayList<Mapping>();
            this.autoIncMappings.put(mapping.getName(), list);
        }
        list.add(mapping);
    }

    public TypeMapping getTypeMapping(String name, long size) {
        TypeMapping result = null;
        List list = (List)this.mappings.get(name);
        if (list != null) {
            result = this.getTypeMapping(list, size);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTypeMapping(" + name + ", " + size + ") => " + result));
        }
        return result;
    }

    public TypeMapping getAutoIncrementMapping(String name, long size) {
        TypeMapping result = null;
        List list = (List)this.autoIncMappings.get(name);
        if (list != null) {
            result = this.getTypeMapping(list, size);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAutoIncrementMapping(" + name + ", " + size + ") => " + result));
        }
        return result;
    }

    public TypeMapping promote(String name, long size) {
        TypeMapping result = null;
        if (TypeMap.isVarChar(name)) {
            result = this.promote(name, size, TypeMap.VARCHARS);
        } else if (TypeMap.isExactNumeric(name)) {
            result = this.promote(name, size, TypeMap.EXACT_NUMERICS, "NUMERIC");
        } else if (TypeMap.isApproxNumeric(name)) {
            result = this.promote(name, size, TypeMap.APPROX_NUMERICS);
        }
        return result;
    }

    public TypeMapping promote(String fromName, String toName, long size) {
        TypeMapping result = null;
        boolean valid = false;
        if (TypeMap.isVarChar(fromName) && TypeMap.isVarChar(toName)) {
            valid = true;
        } else if (TypeMap.isExactNumeric(fromName) && TypeMap.isExactNumeric(toName)) {
            valid = true;
        } else if (TypeMap.isApproxNumeric(fromName) && TypeMap.isApproxNumeric(toName)) {
            valid = true;
        }
        if (valid) {
            result = this.getTypeMapping(toName, size);
        }
        return result;
    }

    public String getSQLType(Column column) {
        String result = null;
        TypeMapping mapping = this.getTypeMapping(column.getType(), (long)column.getSize());
        if (mapping != null) {
            result = mapping.getSQLType(column);
        }
        return result;
    }

    protected TypeMapping getTypeMapping(List mappings, long size) {
        TypeMapping result = null;
        Iterator iterator = mappings.iterator();
        Mapping mapping = null;
        Type type = null;
        while (iterator.hasNext()) {
            mapping = (Mapping)iterator.next();
            type = this.getType(mapping.getSQLName());
            if (type == null) {
                throw new IllegalStateException("Invalid mapping " + mapping + ". Type " + mapping.getSQLName() + " does not exist");
            }
            if (size == type.getSize()) {
                result = new TypeMapping(type, mapping);
                break;
            }
            if (result == null) {
                result = new TypeMapping(type, mapping);
                continue;
            }
            if (size < type.getSize()) {
                if (type.getSize() >= result.getSize()) continue;
                result.setType(type);
                continue;
            }
            if (type.getSize() <= result.getSize()) continue;
            result.setType(type);
        }
        return result;
    }

    protected TypeMapping promote(String name, long size, String[] types) {
        return this.promote(name, size, types, null);
    }

    protected TypeMapping promote(String name, long size, String[] types, String defaultName) {
        int i;
        TypeMapping result = null;
        int index = -1;
        for (i = 0; i < types.length; ++i) {
            if (!types[i].equals(name)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            for (i = index + 1; i < types.length && result == null && (defaultName == null || (result = this.getTypeMapping(defaultName, size)) == null); ++i) {
                result = this.getTypeMapping(types[i], size);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

