/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.type;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.sql.type.Mapping;
import org.apache.commons.sql.type.Type;
import org.apache.commons.sql.type.TypeMap;
import org.apache.commons.sql.type.Types;

public class TypesFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$sql$type$TypesFactory == null ? (class$org$apache$commons$sql$type$TypesFactory = TypesFactory.class$("org.apache.commons.sql.type.TypesFactory")) : class$org$apache$commons$sql$type$TypesFactory));
    static /* synthetic */ Class class$org$apache$commons$sql$type$TypesFactory;

    public static Types create(Connection connection) throws SQLException {
        Types types = new Types();
        HashSet parameterSet = new HashSet();
        DatabaseMetaData metaData = connection.getMetaData();
        TypesFactory.populateTypes(metaData, types, parameterSet);
        TypesFactory.populateMappings(metaData, types, parameterSet);
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateTypes(DatabaseMetaData metaData, Types types, HashSet parameterSet) throws SQLException {
        ResultSet set = null;
        try {
            set = metaData.getTypeInfo();
            while (set.next()) {
                Type type;
                String sqlName = set.getString("TYPE_NAME");
                int typeCode = set.getInt("DATA_TYPE");
                long precision = set.getLong("PRECISION");
                short minScale = set.getShort("MINIMUM_SCALE");
                short maxScale = set.getShort("MAXIMUM_SCALE");
                String createParams = set.getString("CREATE_PARAMS");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TypeInfo: [TYPE_NAME=" + sqlName + ";DATA_TYPE=" + typeCode + ";PRECISION=" + precision + ";MINIMUM_SCALE=" + minScale + ";MAXIMUM_SCALE=" + maxScale + ";CREATE_PARAMS=" + createParams + "]"));
                }
                if ((type = types.getType(sqlName)) == null || precision > type.getSize()) {
                    type = new Type(sqlName, precision, minScale, maxScale);
                    types.addType(type);
                }
                if (createParams == null || createParams.length() == 0) continue;
                parameterSet.add(sqlName);
            }
        }
        finally {
            if (set != null) {
                set.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateMappings(DatabaseMetaData metaData, Types types, HashSet parameterSet) throws SQLException {
        ResultSet set = null;
        try {
            set = metaData.getTypeInfo();
            while (set.next()) {
                String sqlName = set.getString("TYPE_NAME");
                int typeCode = set.getInt("DATA_TYPE");
                long precision = set.getLong("PRECISION");
                short scale = set.getShort("MAXIMUM_SCALE");
                boolean autoIncrement = set.getBoolean("AUTO_INCREMENT");
                String name = TypeMap.getName(typeCode);
                if (name == null) continue;
                String format = null;
                if (parameterSet.contains(sqlName)) {
                    format = TypesFactory.getFormat(typeCode, precision);
                }
                Mapping mapping = new Mapping(name, sqlName, format);
                types.addMapping(mapping);
                if (!autoIncrement) continue;
                types.addAutoIncrementMapping(mapping);
            }
        }
        finally {
            if (set != null) {
                set.close();
            }
        }
    }

    private static String getFormat(int typeCode, long size) {
        String format = null;
        switch (typeCode) {
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                format = "size";
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                format = "(" + size + ")";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                format = "size-scale";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                format = "size";
            }
        }
        return format;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

