/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.util;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.sql.builder.SqlBuilder;
import org.apache.commons.sql.model.Database;
import org.apache.commons.sql.util.JdbcSupport;

public class DDLExecutor
extends JdbcSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$sql$util$DDLExecutor == null ? (class$org$apache$commons$sql$util$DDLExecutor = DDLExecutor.class$("org.apache.commons.sql.util.DDLExecutor")) : class$org$apache$commons$sql$util$DDLExecutor));
    private SqlBuilder sqlBuilder;
    private boolean continueOnError = true;
    static /* synthetic */ Class class$org$apache$commons$sql$util$DDLExecutor;

    public DDLExecutor() {
    }

    public DDLExecutor(DataSource dataSource) {
        super(dataSource);
    }

    public DDLExecutor(DataSource dataSource, SqlBuilder sqlBuilder) {
        super(dataSource);
        this.sqlBuilder = sqlBuilder;
    }

    public void createDatabase(Database database, boolean dropTablesFirst) throws SQLException {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().createDatabase(database, dropTablesFirst);
            sql = buffer.toString();
        }
        catch (IOException e) {
            throw new SQLException("We should never get this exception!!: " + e);
        }
        this.evaluateBatch(sql);
    }

    public void dropDatabase(Database database) throws SQLException {
        String sql = null;
        try {
            StringWriter buffer = new StringWriter();
            this.getSqlBuilder().setWriter(buffer);
            this.getSqlBuilder().dropDatabase(database);
            sql = buffer.toString();
        }
        catch (IOException e) {
            throw new SQLException("We should never get this exception!!: " + e);
        }
        this.evaluateBatch(sql);
    }

    public SqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    public void setSqlBuilder(SqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateBatch(String sql) throws SQLException {
        Connection connection = this.borrowConnection();
        Statement statement = null;
        int errors = 0;
        int commandCount = 0;
        try {
            statement = connection.createStatement();
            StringTokenizer tokenizer = new StringTokenizer(sql, ";");
            while (tokenizer.hasMoreTokens()) {
                String command = tokenizer.nextToken();
                if ((command = command.trim()).length() == 0) continue;
                ++commandCount;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("About to execute sql: " + command));
                }
                if (this.continueOnError) {
                    try {
                        int results = statement.executeUpdate(command);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("returned: " + results + " row(s) changed"));
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)("Command failed: " + command + ". Reason: " + e));
                        ++errors;
                    }
                } else {
                    int results = statement.executeUpdate(command);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("returned: " + results + " row(s) changed"));
                    }
                }
                for (SQLWarning warning = connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    log.warn((Object)warning.toString());
                }
                connection.clearWarnings();
            }
            log.info((Object)("Executed: " + commandCount + " statement(s) with " + errors + " error(s)"));
        }
        finally {
            this.closeStatement(statement);
            this.returnConnection(connection);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

