/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.util;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceWrapper
implements DataSource {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$sql$util$DataSourceWrapper == null ? (class$org$apache$commons$sql$util$DataSourceWrapper = DataSourceWrapper.class$("org.apache.commons.sql.util.DataSourceWrapper")) : class$org$apache$commons$sql$util$DataSourceWrapper));
    private String driverClassName;
    private String jdbcURL;
    private String userName;
    private String password;
    static /* synthetic */ Class class$org$apache$commons$sql$util$DataSourceWrapper;

    public DataSourceWrapper() {
    }

    public DataSourceWrapper(String driverClassName, String jdbcURL) throws ClassNotFoundException {
        this(driverClassName, jdbcURL, null, null);
    }

    public DataSourceWrapper(String driverClassName, String jdbcURL, String userName, String password) throws ClassNotFoundException {
        this.setDriverClassName(driverClassName);
        this.setJdbcURL(jdbcURL);
        this.setUserName(userName);
        this.setPassword(password);
    }

    public void setDriverClassName(String driverClassName) throws ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading JDBC driver: [" + driverClassName + "]"));
        }
        this.driverClassName = driverClassName;
        Class<?> c = Class.forName(driverClassName, true, this.getClass().getClassLoader());
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Connection getConnection() throws SQLException {
        Connection conn = null;
        if (this.userName != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating connection from url: " + this.jdbcURL + " userName: " + this.userName));
            }
            conn = DriverManager.getConnection(this.jdbcURL, this.userName, this.password);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating connection from url: " + this.jdbcURL));
            }
            conn = DriverManager.getConnection(this.jdbcURL);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created connection: " + conn));
        }
        return conn;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public int getLoginTimeout() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public synchronized void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLException("Not Supported");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

