/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.sql.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JdbcSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$sql$util$JdbcSupport == null ? (class$org$apache$commons$sql$util$JdbcSupport = JdbcSupport.class$("org.apache.commons.sql.util.JdbcSupport")) : class$org$apache$commons$sql$util$JdbcSupport));
    private DataSource dataSource;
    static /* synthetic */ Class class$org$apache$commons$sql$util$JdbcSupport;

    public JdbcSupport() {
    }

    public JdbcSupport(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Connection borrowConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    protected void returnConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (Exception e) {
            log.error((Object)("Caught exception while returning connection to pool: " + e), (Throwable)e);
        }
    }

    protected void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("Ignoring exception closing result set: " + e), (Throwable)e);
            }
        }
    }

    protected void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("Ignoring exception closing statement: " + e), (Throwable)e);
            }
        }
    }

    protected void closeResources(Connection connection, Statement statement, ResultSet resultSet) {
        this.closeResultSet(resultSet);
        this.closeStatement(statement);
        this.returnConnection(connection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

