/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.util;

import org.apache.commons.transaction.util.LoggerFacade;

public class TurnBarrier {
    public static final long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    protected final String name;
    protected int currentNumber;
    protected final int startNumber;
    protected final long timeout;
    protected LoggerFacade logger;

    public TurnBarrier(String name, LoggerFacade logger) {
        this(name, Long.MAX_VALUE, logger);
    }

    public TurnBarrier(String name, long timeout, LoggerFacade logger) {
        this(name, timeout, logger, 0);
    }

    public TurnBarrier(String name, long timeout, LoggerFacade logger, int startTurn) {
        this.name = name;
        this.timeout = timeout;
        this.logger = logger;
        this.startNumber = startTurn;
        this.currentNumber = startTurn;
    }

    public synchronized void waitForTurn(int turnNumber) throws InterruptedException, RuntimeException {
        if (turnNumber > this.currentNumber) {
            long started = System.currentTimeMillis();
            long remaining = this.timeout;
            while (remaining > 0L && turnNumber > this.currentNumber) {
                this.wait(remaining);
                remaining = this.timeout - (System.currentTimeMillis() - started);
            }
        }
        if (turnNumber > this.currentNumber) {
            throw new RuntimeException("Timed out while waiting for our turn");
        }
    }

    public synchronized void signalTurn(int turnNumber) {
        this.currentNumber = turnNumber;
        this.notifyAll();
    }

    public synchronized void reset() {
        this.signalTurn(this.startNumber);
    }
}

