/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.transaction.file.NoOpTransactionIdToPathMapper;
import org.apache.commons.transaction.file.ResourceIdToPathMapper;
import org.apache.commons.transaction.file.ResourceManager;
import org.apache.commons.transaction.file.ResourceManagerErrorCodes;
import org.apache.commons.transaction.file.ResourceManagerException;
import org.apache.commons.transaction.file.ResourceManagerSystemException;
import org.apache.commons.transaction.file.TransactionIdToPathMapper;
import org.apache.commons.transaction.file.URLEncodeIdMapper;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.GenericLockManager;
import org.apache.commons.transaction.locking.LockException;
import org.apache.commons.transaction.locking.LockManager2;
import org.apache.commons.transaction.util.FileHelper;
import org.apache.commons.transaction.util.LoggerFacade;

public class FileResourceManager
implements ResourceManager,
ResourceManagerErrorCodes {
    protected static final int NATIVE_ISOLATION_LEVEL = 50;
    protected static final int DEFAULT_ISOLATION_LEVEL = 50;
    protected static final int NO_LOCK = 0;
    protected static final int LOCK_ACCESS = 1;
    protected static final int LOCK_SHARED = 2;
    protected static final int LOCK_EXCLUSIVE = 3;
    protected static final int LOCK_COMMIT = 4;
    protected static final int OPERATION_MODE_STOPPED = 0;
    protected static final int OPERATION_MODE_STOPPING = 1;
    protected static final int OPERATION_MODE_STARTED = 2;
    protected static final int OPERATION_MODE_STARTING = 3;
    protected static final int OPERATION_MODE_RECOVERING = 4;
    protected static final String DEFAULT_PARAMETER_ENCODING = "ISO-8859-15";
    protected static final int DEFAULT_TIMEOUT_MSECS = 5000;
    protected static final int DEFAULT_COMMIT_TIMEOUT_FACTOR = 2;
    protected static final String WORK_CHANGE_DIR = "change";
    protected static final String WORK_DELETE_DIR = "delete";
    protected static final String CONTEXT_FILE = "transaction.log";
    protected String workDir;
    protected String storeDir;
    protected boolean cleanUp = true;
    protected boolean dirty = false;
    protected int operationMode = 0;
    protected long defaultTimeout = 5000L;
    protected boolean debug;
    protected LoggerFacade logger;
    protected Map globalTransactions;
    protected List globalOpenResources;
    protected LockManager2 lockManager;
    protected ResourceIdToPathMapper idMapper = null;
    protected TransactionIdToPathMapper txIdMapper = null;
    protected int idCnt = 0;

    protected static void applyDeletes(File removeDir, File targetDir, File rootDir) throws IOException {
        if (removeDir.isDirectory() && targetDir.isDirectory()) {
            File[] files = removeDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File removeFile = files[i];
                File targetFile = new File(targetDir, removeFile.getName());
                if (removeFile.isFile()) {
                    if (targetFile.exists() && !targetFile.delete()) {
                        throw new IOException("Could not delete file " + removeFile.getName() + " in directory targetDir");
                    }
                    removeFile.delete();
                } else {
                    FileResourceManager.applyDeletes(removeFile, targetFile, rootDir);
                }
                if (targetDir.equals(rootDir) || targetDir.list().length != 0) continue;
                targetDir.delete();
            }
        }
    }

    public FileResourceManager(String storeDir, String workDir, boolean urlEncodePath, LoggerFacade logger) {
        this(storeDir, workDir, urlEncodePath, logger, false);
    }

    public FileResourceManager(String storeDir, String workDir, boolean urlEncodePath, LoggerFacade logger, boolean debug) {
        this(storeDir, workDir, urlEncodePath ? new URLEncodeIdMapper() : null, new NoOpTransactionIdToPathMapper(), logger, debug);
    }

    public FileResourceManager(String storeDir, String workDir, ResourceIdToPathMapper idMapper, LoggerFacade logger, boolean debug) {
        this(storeDir, workDir, idMapper, new NoOpTransactionIdToPathMapper(), logger, debug);
    }

    public FileResourceManager(String storeDir, String workDir, ResourceIdToPathMapper idMapper, TransactionIdToPathMapper txIdMapper, LoggerFacade logger, boolean debug) {
        this.workDir = workDir;
        this.storeDir = storeDir;
        this.idMapper = idMapper;
        this.txIdMapper = txIdMapper;
        this.logger = logger;
        this.debug = debug;
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public LoggerFacade getLogger() {
        return this.logger;
    }

    public boolean lockResource(Object resourceId, Object txId) throws ResourceManagerException {
        this.lockResource(resourceId, txId, false);
        return true;
    }

    public boolean lockResource(Object resourceId, Object txId, boolean shared) throws ResourceManagerException {
        this.lockResource(resourceId, txId, shared, true, Long.MAX_VALUE, true);
        return true;
    }

    public boolean lockResource(Object resourceId, Object txId, boolean shared, boolean wait, long timeoutMSecs, boolean reentrant) throws ResourceManagerException {
        TransactionContext context = shared ? this.txInitialSaneCheck(txId) : this.txInitialSaneCheckForWriting(txId);
        this.assureNotMarkedForRollback(context);
        this.fileInitialSaneCheck(txId, resourceId);
        int level = shared ? this.getSharedLockLevel(context) : 3;
        try {
            this.lockManager.lock(txId, resourceId, level, reentrant, Math.min(timeoutMSecs, context.timeoutMSecs));
            return true;
        }
        catch (LockException e) {
            switch (e.getCode()) {
                case 1: {
                    throw new ResourceManagerException("Could not get lock for resource at '" + resourceId + "'", 5001, txId);
                }
                case 2: {
                    throw new ResourceManagerException("Lock timed out for resource at '" + resourceId + "'", 5001, txId);
                }
                case 3: {
                    throw new ResourceManagerException("Deadlock victim resource at '" + resourceId + "'", 5002, txId);
                }
            }
            throw new ResourceManagerException("Locking exception for resource at '" + resourceId + "'", 5002, txId);
        }
    }

    public int getDefaultIsolationLevel() {
        return 50;
    }

    public int[] getSupportedIsolationLevels() throws ResourceManagerException {
        return new int[]{10, 50};
    }

    public boolean isIsolationLevelSupported(int level) throws ResourceManagerException {
        return level == 10 || level == 50;
    }

    public long getDefaultTransactionTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTransactionTimeout(long timeout) {
        this.defaultTimeout = timeout;
    }

    public long getTransactionTimeout(Object txId) throws ResourceManagerException {
        this.assureRMReady();
        long msecs = 0L;
        TransactionContext context = this.getContext(txId);
        msecs = context == null ? this.getDefaultTransactionTimeout() : context.timeoutMSecs;
        return msecs;
    }

    public void setTransactionTimeout(Object txId, long mSecs) throws ResourceManagerException {
        this.assureRMReady();
        TransactionContext context = this.getContext(txId);
        if (context == null) {
            throw new ResourceManagerException(1000, txId);
        }
        context.timeoutMSecs = mSecs;
    }

    public int getIsolationLevel(Object txId) throws ResourceManagerException {
        this.assureRMReady();
        TransactionContext context = this.getContext(txId);
        if (context == null) {
            return 50;
        }
        return context.isolationLevel;
    }

    public void setIsolationLevel(Object txId, int level) throws ResourceManagerException {
        this.assureRMReady();
        TransactionContext context = this.getContext(txId);
        if (context != null) {
            if (level == 10 && level == 50) {
                throw new ResourceManagerException(1006, txId);
            }
        } else {
            throw new ResourceManagerException(1000, txId);
        }
        context.isolationLevel = level;
    }

    public synchronized void start() throws ResourceManagerSystemException {
        this.logger.logInfo("Starting RM at '" + this.storeDir + "' / '" + this.workDir + "'");
        this.operationMode = 3;
        this.globalTransactions = Collections.synchronizedMap(new HashMap());
        this.lockManager = new GenericLockManager(4, this.logger);
        this.globalOpenResources = Collections.synchronizedList(new ArrayList());
        this.recover();
        this.sync();
        this.operationMode = 2;
        if (this.dirty) {
            this.logger.logWarning("Started RM, but in dirty mode only (Recovery of pending transactions failed)");
        } else {
            this.logger.logInfo("Started RM");
        }
    }

    public synchronized boolean stop(int mode) throws ResourceManagerSystemException {
        return this.stop(mode, this.getDefaultTransactionTimeout() * 2L);
    }

    public synchronized boolean stop(int mode, long timeOut) throws ResourceManagerSystemException {
        this.logger.logInfo("Stopping RM at '" + this.storeDir + "' / '" + this.workDir + "'");
        this.operationMode = 1;
        this.sync();
        boolean success = this.shutdown(mode, timeOut);
        this.releaseGlobalOpenResources();
        if (success) {
            this.operationMode = 0;
            this.logger.logInfo("Stopped RM");
        } else {
            this.logger.logWarning("Failed to stop RM");
        }
        return success;
    }

    public synchronized boolean recover() throws ResourceManagerSystemException {
        if (this.operationMode != 2 && this.operationMode != 3) {
            throw new ResourceManagerSystemException(1, "Recovery is possible in started or starting resource manager only");
        }
        int oldMode = this.operationMode;
        this.operationMode = 4;
        this.recoverContexts();
        if (this.globalTransactions.size() > 0) {
            this.logger.logInfo("Recovering pending transactions");
        }
        this.dirty = !this.rollBackOrForward();
        this.operationMode = oldMode;
        return this.dirty;
    }

    public int getTransactionState(Object txId) throws ResourceManagerException {
        TransactionContext context = this.getContext(txId);
        if (context == null) {
            return 6;
        }
        return context.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransaction(Object txId) throws ResourceManagerException {
        if (this.logger.isFineEnabled()) {
            this.logger.logFine("Starting Tx " + txId);
        }
        this.assureStarted();
        if (txId == null || this.txIdMapper.getPathForId(txId).length() == 0) {
            throw new ResourceManagerException(1001, txId);
        }
        Map map = this.globalTransactions;
        synchronized (map) {
            TransactionContext context = this.getContext(txId);
            if (context != null) {
                throw new ResourceManagerException(1004, txId);
            }
            context = new TransactionContext(txId);
            context.init();
            this.globalTransactions.put(txId, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markTransactionForRollback(Object txId) throws ResourceManagerException {
        this.assureRMReady();
        TransactionContext context = this.txInitialSaneCheckForWriting(txId);
        try {
            context.status = 1;
            context.saveState();
        }
        finally {
            context.finalCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepareTransaction(Object txId) throws ResourceManagerException {
        this.assureRMReady();
        if (this.dirty) {
            throw new ResourceManagerSystemException("Database is set to dirty, this *may* mean it is corrupt. No modifications are allowed until a recovery run has been performed!", 1, txId);
        }
        if (txId == null) {
            throw new ResourceManagerException(1001, txId);
        }
        TransactionContext context = this.getContext(txId);
        if (context == null) {
            return -1;
        }
        TransactionContext transactionContext = context;
        synchronized (transactionContext) {
            this.sync();
            if (context.status != 0) {
                context.status = 1;
                context.saveState();
                return -1;
            }
            if (this.logger.isFineEnabled()) {
                this.logger.logFine("Preparing Tx " + txId);
            }
            int prepareStatus = -1;
            context.status = 7;
            context.saveState();
            context.closeResources();
            if (context.readOnly) {
                prepareStatus = 2;
            } else {
                try {
                    context.upgradeLockToCommit();
                }
                catch (ResourceManagerException rme) {
                    this.markTransactionForRollback(txId);
                    throw rme;
                }
                prepareStatus = 1;
            }
            context.status = 2;
            context.saveState();
            if (this.logger.isFineEnabled()) {
                this.logger.logFine("Prepared Tx " + txId);
            }
            return prepareStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(Object txId) throws ResourceManagerException {
        TransactionContext context;
        this.assureRMReady();
        TransactionContext transactionContext = context = this.txInitialSaneCheckForWriting(txId);
        synchronized (transactionContext) {
            try {
                if (this.logger.isFineEnabled()) {
                    this.logger.logFine("Rolling back Tx " + txId);
                }
                context.status = 9;
                context.saveState();
                context.rollback();
                context.status = 4;
                context.saveState();
                this.globalTransactions.remove(txId);
                context.cleanUp();
                if (this.logger.isFineEnabled()) {
                    this.logger.logFine("Rolled back Tx " + txId);
                }
            }
            catch (Error e) {
                this.setDirty(txId, e);
                throw e;
            }
            catch (RuntimeException e) {
                this.setDirty(txId, e);
                throw e;
            }
            catch (ResourceManagerSystemException e) {
                this.setDirty(txId, e);
                throw e;
            }
            finally {
                context.finalCleanUp();
                context.notifyFinish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(Object txId) throws ResourceManagerException {
        this.assureRMReady();
        TransactionContext context = this.txInitialSaneCheckForWriting(txId);
        this.assureNotMarkedForRollback(context);
        TransactionContext transactionContext = context;
        synchronized (transactionContext) {
            try {
                if (this.logger.isFineEnabled()) {
                    this.logger.logFine("Committing Tx " + txId);
                }
                context.status = 8;
                context.saveState();
                context.commit();
                context.status = 3;
                context.saveState();
                this.globalTransactions.remove(txId);
                context.cleanUp();
                if (this.logger.isFineEnabled()) {
                    this.logger.logFine("Committed Tx " + txId);
                }
            }
            catch (Error e) {
                this.setDirty(txId, e);
                throw e;
            }
            catch (RuntimeException e) {
                this.setDirty(txId, e);
                throw e;
            }
            catch (ResourceManagerSystemException e) {
                this.setDirty(txId, e);
                throw e;
            }
            catch (ResourceManagerException e) {
                this.logger.logWarning("Could not commit tx " + txId + ", rolling back instead", e);
                this.rollbackTransaction(txId);
            }
            finally {
                context.finalCleanUp();
                context.notifyFinish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourceExists(Object resourceId) throws ResourceManagerException {
        TransactionContext context;
        String txId;
        Map map = this.globalTransactions;
        synchronized (map) {
            txId = this.generatedUniqueTxId();
            if (this.logger.isFinerEnabled()) {
                this.logger.logFiner("Creating temporary light weight tx " + txId + " to check for exists");
            }
            context = new TransactionContext(txId);
            context.isLightWeight = true;
            context.isolationLevel = 10;
            this.globalTransactions.put(txId, context);
        }
        boolean exists = this.resourceExists(txId, resourceId);
        context.freeLocks();
        this.globalTransactions.remove(txId);
        if (this.logger.isFinerEnabled()) {
            this.logger.logFiner("Removing temporary light weight tx " + txId);
        }
        return exists;
    }

    public boolean resourceExists(Object txId, Object resourceId) throws ResourceManagerException {
        this.lockResource(resourceId, txId, true);
        return this.getPathForRead(txId, resourceId) != null;
    }

    public void deleteResource(Object txId, Object resourceId) throws ResourceManagerException {
        this.deleteResource(txId, resourceId, true);
    }

    public void deleteResource(Object txId, Object resourceId, boolean assureOnly) throws ResourceManagerException {
        if (this.logger.isFineEnabled()) {
            this.logger.logFine(txId + " deleting " + resourceId);
        }
        this.lockResource(resourceId, txId, false);
        if (this.getPathForRead(txId, resourceId) == null) {
            if (assureOnly) {
                return;
            }
            throw new ResourceManagerException("No such resource at '" + resourceId + "'", 4002, txId);
        }
        String txDeletePath = this.getDeletePath(txId, resourceId);
        String mainPath = this.getMainPath(resourceId);
        try {
            this.getContext((Object)txId).readOnly = false;
            this.undoScheduledChangeOrCreate(txId, resourceId);
            if (FileHelper.fileExists(mainPath)) {
                FileHelper.createFile(txDeletePath);
            }
        }
        catch (IOException e) {
            throw new ResourceManagerSystemException("Can not delete resource at '" + resourceId + "'", 1, txId, e);
        }
    }

    public void createResource(Object txId, Object resourceId) throws ResourceManagerException {
        this.createResource(txId, resourceId, true);
    }

    public void createResource(Object txId, Object resourceId, boolean assureOnly) throws ResourceManagerException {
        if (this.logger.isFineEnabled()) {
            this.logger.logFine(txId + " creating " + resourceId);
        }
        this.lockResource(resourceId, txId, false);
        if (this.getPathForRead(txId, resourceId) != null) {
            if (assureOnly) {
                return;
            }
            throw new ResourceManagerException("Resource at '" + resourceId + "', already exists", 4001, txId);
        }
        String txChangePath = this.getChangePath(txId, resourceId);
        try {
            this.getContext((Object)txId).readOnly = false;
            if (!this.undoScheduledDelete(txId, resourceId)) {
                FileHelper.createFile(txChangePath);
            }
        }
        catch (IOException e) {
            throw new ResourceManagerSystemException("Can not create resource at '" + resourceId + "'", 1, txId, e);
        }
    }

    public void copyResource(Object txId, Object fromResourceId, Object toResourceId, boolean overwrite) throws ResourceManagerException {
        if (this.logger.isFineEnabled()) {
            this.logger.logFine(txId + " copying " + fromResourceId + " to " + toResourceId);
        }
        this.lockResource(fromResourceId, txId, true);
        this.lockResource(toResourceId, txId, false);
        if (this.resourceExists(txId, toResourceId) && !overwrite) {
            throw new ResourceManagerException("Resource at '" + toResourceId + "' already exists", 4001, txId);
        }
        InputStream fromResourceStream = null;
        OutputStream toResourceStream = null;
        try {
            fromResourceStream = this.readResource(txId, fromResourceId);
            toResourceStream = this.writeResource(txId, toResourceId);
            FileHelper.copy(fromResourceStream, toResourceStream);
            this.closeOpenResource(fromResourceStream);
            this.closeOpenResource(toResourceStream);
        }
        catch (IOException e) {
            try {
                throw new ResourceManagerException(1, txId, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeOpenResource(fromResourceStream);
                this.closeOpenResource(toResourceStream);
                throw throwable;
            }
        }
    }

    public void moveResource(Object txId, Object fromResourceId, Object toResourceId, boolean overwrite) throws ResourceManagerException {
        if (this.logger.isFineEnabled()) {
            this.logger.logFine(txId + " moving " + fromResourceId + " to " + toResourceId);
        }
        this.lockResource(fromResourceId, txId, false);
        this.lockResource(toResourceId, txId, false);
        this.copyResource(txId, fromResourceId, toResourceId, overwrite);
        this.deleteResource(txId, fromResourceId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readResource(Object resourceId) throws ResourceManagerException {
        String txId;
        Map map = this.globalTransactions;
        synchronized (map) {
            txId = this.generatedUniqueTxId();
            if (this.logger.isFinerEnabled()) {
                this.logger.logFiner("Creating temporary light weight tx " + txId + " for reading");
            }
            TransactionContext context = new TransactionContext(txId);
            context.isLightWeight = true;
            context.isolationLevel = 10;
            this.globalTransactions.put(txId, context);
        }
        InputStream is = this.readResource(txId, resourceId);
        return is;
    }

    public InputStream readResource(Object txId, Object resourceId) throws ResourceManagerException {
        if (this.logger.isFineEnabled()) {
            this.logger.logFine(txId + " reading " + resourceId);
        }
        this.lockResource(resourceId, txId, true);
        String resourcePath = this.getPathForRead(txId, resourceId);
        if (resourcePath == null) {
            throw new ResourceManagerException("No such resource at '" + resourceId + "'", 4002, txId);
        }
        File file = new File(resourcePath);
        try {
            FileInputStream stream = new FileInputStream(file);
            this.getContext(txId).registerResource(stream);
            return new InputStreamWrapper(stream, txId, resourceId);
        }
        catch (FileNotFoundException e) {
            throw new ResourceManagerSystemException("File '" + resourcePath + "' does not exist", 1, txId);
        }
    }

    public OutputStream writeResource(Object txId, Object resourceId) throws ResourceManagerException {
        return this.writeResource(txId, resourceId, false);
    }

    public OutputStream writeResource(Object txId, Object resourceId, boolean append) throws ResourceManagerException {
        if (this.logger.isFineEnabled()) {
            this.logger.logFine(txId + " writing " + resourceId);
        }
        this.lockResource(resourceId, txId, false);
        if (append) {
            String mainPath = this.getMainPath(resourceId);
            String txChangePath = this.getChangePath(txId, resourceId);
            String txDeletePath = this.getDeletePath(txId, resourceId);
            boolean changeExists = FileHelper.fileExists(txChangePath);
            boolean deleteExists = FileHelper.fileExists(txDeletePath);
            boolean mainExists = FileHelper.fileExists(mainPath);
            if (mainExists && !changeExists && !deleteExists) {
                this.copyResource(txId, resourceId, resourceId, true);
            }
        }
        String resourcePath = this.getPathForWrite(txId, resourceId);
        try {
            FileOutputStream stream = new FileOutputStream(resourcePath, append);
            TransactionContext context = this.getContext(txId);
            context.registerResource(stream);
            context.readOnly = false;
            return stream;
        }
        catch (FileNotFoundException e) {
            throw new ResourceManagerSystemException("File '" + resourcePath + "' does not exist", 1, txId);
        }
    }

    public synchronized void reset() {
        FileHelper.removeRec(new File(this.storeDir));
        FileHelper.removeRec(new File(this.workDir));
        new File(this.storeDir).mkdirs();
        new File(this.workDir).mkdirs();
    }

    public synchronized void sync() throws ResourceManagerSystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generatedUniqueTxId() throws ResourceManagerSystemException {
        String txId;
        this.assureRMReady();
        Map map = this.globalTransactions;
        synchronized (map) {
            while (this.getContext(txId = Long.toHexString(System.currentTimeMillis()) + "-" + Integer.toHexString(this.idCnt++)) != null) {
            }
        }
        return txId;
    }

    protected void fileInitialSaneCheck(Object txId, Object path) throws ResourceManagerException {
        if (path == null || path.toString().length() == 0) {
            throw new ResourceManagerException(4000, txId);
        }
    }

    protected void assureStarted() throws ResourceManagerSystemException {
        if (this.operationMode != 2) {
            throw new ResourceManagerSystemException("Resource Manager Service not started", 1, (Object)null);
        }
    }

    protected void assureRMReady() throws ResourceManagerSystemException {
        if (this.operationMode != 2 && this.operationMode != 1) {
            throw new ResourceManagerSystemException("Resource Manager Service not ready", 1, (Object)null);
        }
    }

    protected void assureNotMarkedForRollback(TransactionContext context) throws ResourceManagerException {
        if (context.status == 1) {
            throw new ResourceManagerException(1007, context.txId);
        }
    }

    protected TransactionContext txInitialSaneCheckForWriting(Object txId) throws ResourceManagerException {
        this.assureRMReady();
        if (this.dirty) {
            throw new ResourceManagerSystemException("Database is set to dirty, this *may* mean it is corrupt. No modifications are allowed until a recovery run has been performed!", 1, txId);
        }
        return this.txInitialSaneCheck(txId);
    }

    protected TransactionContext txInitialSaneCheck(Object txId) throws ResourceManagerException {
        this.assureRMReady();
        if (txId == null) {
            throw new ResourceManagerException(1001, txId);
        }
        TransactionContext context = this.getContext(txId);
        if (context == null) {
            throw new ResourceManagerException(1000, txId);
        }
        return context;
    }

    protected TransactionContext getContext(Object txId) {
        return (TransactionContext)this.globalTransactions.get(txId);
    }

    protected String assureLeadingSlash(Object pathObject) {
        String path = "";
        if (pathObject != null && (path = this.idMapper != null ? this.idMapper.getPathForId(pathObject) : pathObject.toString()).length() > 0 && path.charAt(0) != '/' && path.charAt(0) != '\\') {
            path = "/" + path;
        }
        return path;
    }

    protected String getMainPath(Object path) {
        StringBuffer buf = new StringBuffer(this.storeDir.length() + path.toString().length() + 5);
        buf.append(this.storeDir).append(this.assureLeadingSlash(path));
        return buf.toString();
    }

    protected String getTransactionBaseDir(Object txId) {
        return this.workDir + '/' + this.txIdMapper.getPathForId(txId);
    }

    protected String getChangePath(Object txId, Object path) {
        String txBaseDir = this.getTransactionBaseDir(txId);
        StringBuffer buf = new StringBuffer(txBaseDir.length() + path.toString().length() + WORK_CHANGE_DIR.length() + 5);
        buf.append(txBaseDir).append('/').append(WORK_CHANGE_DIR).append(this.assureLeadingSlash(path));
        return buf.toString();
    }

    protected String getDeletePath(Object txId, Object path) {
        String txBaseDir = this.getTransactionBaseDir(txId);
        StringBuffer buf = new StringBuffer(txBaseDir.length() + path.toString().length() + WORK_DELETE_DIR.length() + 5);
        buf.append(txBaseDir).append('/').append(WORK_DELETE_DIR).append(this.assureLeadingSlash(path));
        return buf.toString();
    }

    protected boolean undoScheduledDelete(Object txId, Object resourceId) throws ResourceManagerException {
        String txDeletePath = this.getDeletePath(txId, resourceId);
        File deleteFile = new File(txDeletePath);
        if (deleteFile.exists()) {
            if (!deleteFile.delete()) {
                throw new ResourceManagerSystemException("Failed to undo delete of '" + resourceId + "'", 1, txId);
            }
            return true;
        }
        return false;
    }

    protected boolean undoScheduledChangeOrCreate(Object txId, Object resourceId) throws ResourceManagerException {
        String txChangePath = this.getChangePath(txId, resourceId);
        File changeFile = new File(txChangePath);
        if (changeFile.exists()) {
            if (!changeFile.delete()) {
                throw new ResourceManagerSystemException("Failed to undo change / create of '" + resourceId + "'", 1, txId);
            }
            return true;
        }
        return false;
    }

    protected String getPathForWrite(Object txId, Object resourceId) throws ResourceManagerException {
        try {
            String txChangePath = this.getChangePath(txId, resourceId);
            if (!FileHelper.fileExists(txChangePath)) {
                FileHelper.createFile(txChangePath);
            }
            return txChangePath;
        }
        catch (IOException e) {
            throw new ResourceManagerSystemException("Can not write to resource at '" + resourceId + "'", 1, txId, e);
        }
    }

    protected String getPathForRead(Object txId, Object resourceId) throws ResourceManagerException {
        boolean resourceIsDir;
        String mainPath = this.getMainPath(resourceId);
        String txChangePath = this.getChangePath(txId, resourceId);
        String txDeletePath = this.getDeletePath(txId, resourceId);
        boolean changeExists = FileHelper.fileExists(txChangePath);
        boolean deleteExists = FileHelper.fileExists(txDeletePath);
        boolean mainExists = FileHelper.fileExists(mainPath);
        boolean bl = resourceIsDir = mainExists && new File(mainPath).isDirectory() || changeExists && new File(txChangePath).isDirectory();
        if (resourceIsDir) {
            this.logger.logWarning("Resource at '" + resourceId + "' maps to directory");
        }
        if (!resourceIsDir && changeExists && deleteExists) {
            throw new ResourceManagerSystemException("Inconsistent delete and change combination for resource at '" + resourceId + "'", 3, txId);
        }
        if (deleteExists && !mainExists) {
            throw new ResourceManagerSystemException("Inconsistent delete for resource at '" + resourceId + "'", 3, txId);
        }
        if (changeExists) {
            return txChangePath;
        }
        if (mainExists && !deleteExists) {
            return mainPath;
        }
        return null;
    }

    protected int getSharedLockLevel(TransactionContext context) throws ResourceManagerException {
        if (context.isolationLevel == 10 || context.isolationLevel == 0) {
            return 1;
        }
        if (context.isolationLevel == 50 || context.isolationLevel == 100) {
            return 2;
        }
        return 1;
    }

    protected void registerOpenResource(Object openResource) {
        if (this.logger.isFinerEnabled()) {
            this.logger.logFiner("Registering open resource " + openResource);
        }
        this.globalOpenResources.add(openResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseGlobalOpenResources() {
        List list = this.globalOpenResources;
        synchronized (list) {
            ArrayList copy = new ArrayList(this.globalOpenResources);
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                Object stream = it.next();
                this.closeOpenResource(stream);
            }
        }
    }

    protected void closeOpenResource(Object openResource) {
        if (this.logger.isFinerEnabled()) {
            this.logger.logFiner("Releasing resource " + openResource);
        }
        this.globalOpenResources.remove(openResource);
        if (openResource instanceof InputStream) {
            InputStream is = (InputStream)openResource;
            try {
                is.close();
            }
            catch (IOException e) {}
        } else if (openResource instanceof OutputStream) {
            OutputStream os = (OutputStream)openResource;
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rollBackOrForward() {
        boolean allCool = true;
        Map map = this.globalTransactions;
        synchronized (map) {
            ArrayList contexts = new ArrayList(this.globalTransactions.values());
            Iterator it = contexts.iterator();
            while (it.hasNext()) {
                TransactionContext context = (TransactionContext)it.next();
                if (context.status == 8) {
                    this.logger.logInfo("Rolling forward " + context.txId);
                    try {
                        context.commit();
                        context.status = 3;
                        context.saveState();
                        this.globalTransactions.remove(context.txId);
                        context.cleanUp();
                    }
                    catch (ResourceManagerException e) {
                        allCool = false;
                        this.logger.logSevere("Rolling forward of " + context.txId + " failed", e);
                    }
                    continue;
                }
                if (context.status == 3) {
                    this.logger.logInfo("Cleaning already commited " + context.txId);
                    this.globalTransactions.remove(context.txId);
                    try {
                        context.cleanUp();
                    }
                    catch (ResourceManagerException e) {
                        allCool = false;
                        this.logger.logWarning("Cleaning of " + context.txId + " failed", e);
                    }
                    continue;
                }
                if (context.status != 9 && context.status != 4 && context.status != 1) {
                    this.logger.logWarning("Irregularly rolling back " + context.txId);
                } else {
                    this.logger.logInfo("Rolling back " + context.txId);
                }
                try {
                    context.rollback();
                    context.status = 4;
                    context.saveState();
                    this.globalTransactions.remove(context.txId);
                    context.cleanUp();
                }
                catch (ResourceManagerException e) {
                    this.logger.logWarning("Rolling back of " + context.txId + " failed", e);
                }
            }
        }
        return allCool;
    }

    protected void recoverContexts() {
        File dir = new File(this.workDir);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            Object txId = this.txIdMapper.getIdForPath(file.getName());
            if (this.globalTransactions.containsKey(txId)) continue;
            this.logger.logInfo("Recovering " + txId);
            try {
                TransactionContext context = new TransactionContext(txId);
                context.recoverState();
                this.globalTransactions.put(txId, context);
                continue;
            }
            catch (ResourceManagerException e) {
                this.logger.logWarning("Recovering of " + txId + " failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForAllTxToStop(long timeoutMSecs) {
        ArrayList transactionsToStop;
        long startTime = System.currentTimeMillis();
        Map map = this.globalTransactions;
        synchronized (map) {
            transactionsToStop = new ArrayList(this.globalTransactions.values());
        }
        Iterator it = transactionsToStop.iterator();
        while (it.hasNext()) {
            TransactionContext context;
            long remainingTimeout = startTime - System.currentTimeMillis() + timeoutMSecs;
            if (remainingTimeout <= 0L) {
                return false;
            }
            TransactionContext transactionContext = context = (TransactionContext)it.next();
            synchronized (transactionContext) {
                if (!context.finished) {
                    this.logger.logInfo("Waiting for tx " + context.txId + " to finish for " + remainingTimeout + " milli seconds");
                }
                while (!context.finished && remainingTimeout > 0L) {
                    try {
                        context.wait(remainingTimeout);
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                    remainingTimeout = startTime - System.currentTimeMillis() + timeoutMSecs;
                }
                if (context.finished) {
                    this.logger.logInfo("Tx " + context.txId + " finished");
                } else {
                    this.logger.logWarning("Tx " + context.txId + " failed to finish in given time");
                }
            }
        }
        return this.globalTransactions.size() == 0;
    }

    protected boolean shutdown(int mode, long timeoutMSecs) {
        switch (mode) {
            case 0: {
                return this.waitForAllTxToStop(timeoutMSecs);
            }
            case 1: {
                return this.rollBackOrForward();
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected void setDirty(Object txId, Throwable t) {
        this.logger.logSevere("Fatal error during critical commit/rollback of transaction " + txId + ", setting database to dirty.", t);
        this.dirty = true;
    }

    private class InputStreamWrapper
    extends InputStream {
        private InputStream is;
        private Object txId;
        private Object resourceId;

        public InputStreamWrapper(InputStream is, Object txId, Object resourceId) {
            this.is = is;
            this.txId = txId;
            this.resourceId = resourceId;
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        public int available() throws IOException {
            return this.is.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            TransactionContext context2;
            Object object;
            try {
                this.is.close();
                Object var2_1 = null;
                object = FileResourceManager.this.globalTransactions;
            }
            catch (Throwable throwable) {
                TransactionContext context2;
                Object var2_2 = null;
                Object object2 = FileResourceManager.this.globalTransactions;
                synchronized (object2) {
                    context2 = FileResourceManager.this.getContext(this.txId);
                    if (context2 == null) {
                        return;
                    }
                }
                object2 = context2;
                synchronized (object2) {
                    if (context2.isLightWeight) {
                        if (FileResourceManager.this.logger.isFinerEnabled()) {
                            FileResourceManager.this.logger.logFiner("Upon close of resource removing temporary light weight tx " + this.txId);
                        }
                        context2.freeLocks();
                        FileResourceManager.this.globalTransactions.remove(this.txId);
                    } else if (FileResourceManager.this.lockManager.getLevel(this.txId, this.resourceId) == 1) {
                        if (FileResourceManager.this.logger.isFinerEnabled()) {
                            FileResourceManager.this.logger.logFiner("Upon close of resource releasing access lock for tx " + this.txId + " on resource at " + this.resourceId);
                        }
                        FileResourceManager.this.lockManager.release(this.txId, this.resourceId);
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                context2 = FileResourceManager.this.getContext(this.txId);
                if (context2 == null) {
                    return;
                }
            }
            object = context2;
            synchronized (object) {
                if (context2.isLightWeight) {
                    if (FileResourceManager.this.logger.isFinerEnabled()) {
                        FileResourceManager.this.logger.logFiner("Upon close of resource removing temporary light weight tx " + this.txId);
                    }
                    context2.freeLocks();
                    FileResourceManager.this.globalTransactions.remove(this.txId);
                } else if (FileResourceManager.this.lockManager.getLevel(this.txId, this.resourceId) == 1) {
                    if (FileResourceManager.this.logger.isFinerEnabled()) {
                        FileResourceManager.this.logger.logFiner("Upon close of resource releasing access lock for tx " + this.txId + " on resource at " + this.resourceId);
                    }
                    FileResourceManager.this.lockManager.release(this.txId, this.resourceId);
                }
            }
        }

        public void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }
    }

    protected class TransactionContext {
        protected Object txId;
        protected int status = 0;
        protected int isolationLevel = 50;
        protected long timeoutMSecs = FileResourceManager.this.getDefaultTransactionTimeout();
        protected long startTime;
        protected long commitTime = -1L;
        protected boolean isLightWeight = false;
        protected boolean readOnly = true;
        protected boolean finished = false;
        private List openResources = new ArrayList();

        public TransactionContext(Object txId) throws ResourceManagerException {
            this.txId = txId;
            this.startTime = System.currentTimeMillis();
        }

        public long getRemainingTimeout() {
            long now = System.currentTimeMillis();
            return this.startTime - now + this.timeoutMSecs;
        }

        public synchronized void init() throws ResourceManagerException {
            String baseDir = FileResourceManager.this.getTransactionBaseDir(this.txId);
            String changeDir = baseDir + "/" + FileResourceManager.WORK_CHANGE_DIR;
            String deleteDir = baseDir + "/" + FileResourceManager.WORK_DELETE_DIR;
            new File(changeDir).mkdirs();
            new File(deleteDir).mkdirs();
            this.saveState();
        }

        public synchronized void rollback() throws ResourceManagerException {
            this.closeResources();
            this.freeLocks();
        }

        public synchronized void commit() throws ResourceManagerException {
            String baseDir = FileResourceManager.this.getTransactionBaseDir(this.txId);
            String changeDir = baseDir + "/" + FileResourceManager.WORK_CHANGE_DIR;
            String deleteDir = baseDir + "/" + FileResourceManager.WORK_DELETE_DIR;
            this.closeResources();
            this.upgradeLockToCommit();
            try {
                FileResourceManager.applyDeletes(new File(deleteDir), new File(FileResourceManager.this.storeDir), new File(FileResourceManager.this.storeDir));
                FileHelper.moveRec(new File(changeDir), new File(FileResourceManager.this.storeDir));
            }
            catch (IOException e) {
                throw new ResourceManagerSystemException("Commit failed", 1, this.txId, e);
            }
            this.freeLocks();
            this.commitTime = System.currentTimeMillis();
        }

        public synchronized void notifyFinish() {
            this.finished = true;
            this.notifyAll();
        }

        public synchronized void cleanUp() throws ResourceManagerException {
            if (!FileResourceManager.this.cleanUp) {
                return;
            }
            boolean clean = true;
            Throwable cleanException = null;
            String baseDir = FileResourceManager.this.getTransactionBaseDir(this.txId);
            FileHelper.removeRec(new File(baseDir));
            if (!clean) {
                throw new ResourceManagerSystemException("Clean up failed due to unreleasable lock", 1, this.txId, cleanException);
            }
        }

        public synchronized void finalCleanUp() throws ResourceManagerException {
            this.closeResources();
            this.freeLocks();
        }

        public synchronized void upgradeLockToCommit() throws ResourceManagerException {
            Iterator it = FileResourceManager.this.lockManager.getAll(this.txId).iterator();
            while (it.hasNext()) {
                GenericLock lock = (GenericLock)it.next();
                if (lock.getLockLevel(this.txId) != 3) continue;
                try {
                    if (lock.acquire(this.txId, 4, true, true, FileResourceManager.this.getDefaultTransactionTimeout() * 2L)) continue;
                    throw new ResourceManagerException("Could not upgrade to commit lock for resource at '" + lock.getResourceId().toString() + "'", 5001, this.txId);
                }
                catch (InterruptedException e) {
                    throw new ResourceManagerSystemException(1, this.txId, (Throwable)e);
                }
            }
        }

        public synchronized void freeLocks() {
            FileResourceManager.this.lockManager.releaseAll(this.txId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void closeResources() {
            List list = FileResourceManager.this.globalOpenResources;
            synchronized (list) {
                Iterator it = this.openResources.iterator();
                while (it.hasNext()) {
                    Object stream = it.next();
                    FileResourceManager.this.closeOpenResource(stream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void registerResource(Object openResource) {
            List list = FileResourceManager.this.globalOpenResources;
            synchronized (list) {
                FileResourceManager.this.registerOpenResource(openResource);
                this.openResources.add(openResource);
            }
        }

        public synchronized void saveState() throws ResourceManagerException {
            String statePath = FileResourceManager.this.getTransactionBaseDir(this.txId) + "/" + FileResourceManager.CONTEXT_FILE;
            File file = new File(statePath);
            BufferedWriter writer = null;
            try {
                FileOutputStream os = new FileOutputStream(file);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, FileResourceManager.DEFAULT_PARAMETER_ENCODING));
                writer.write(this.toString());
            }
            catch (FileNotFoundException e) {
                String msg = "Saving status information to '" + statePath + "' failed! Could not create file";
                FileResourceManager.this.logger.logSevere(msg, e);
                throw new ResourceManagerSystemException(msg, 1, this.txId, e);
            }
            catch (IOException e) {
                String msg = "Saving status information to '" + statePath + "' failed";
                FileResourceManager.this.logger.logSevere(msg, e);
                throw new ResourceManagerSystemException(msg, 1, this.txId, e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        public synchronized void recoverState() throws ResourceManagerException {
            String statePath = FileResourceManager.this.getTransactionBaseDir(this.txId) + "/" + FileResourceManager.CONTEXT_FILE;
            File file = new File(statePath);
            BufferedReader reader = null;
            try {
                FileInputStream is = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader((InputStream)is, FileResourceManager.DEFAULT_PARAMETER_ENCODING));
                this.txId = reader.readLine();
                this.status = Integer.parseInt(reader.readLine());
                this.isolationLevel = Integer.parseInt(reader.readLine());
                this.timeoutMSecs = Long.parseLong(reader.readLine());
                this.startTime = Long.parseLong(reader.readLine());
            }
            catch (FileNotFoundException e) {
                String msg = "Recovering status information from '" + statePath + "' failed! Could not find file";
                FileResourceManager.this.logger.logSevere(msg, e);
                throw new ResourceManagerSystemException(msg, 1, this.txId);
            }
            catch (IOException e) {
                String msg = "Recovering status information from '" + statePath + "' failed";
                FileResourceManager.this.logger.logSevere(msg, e);
                throw new ResourceManagerSystemException(msg, 1, this.txId, e);
            }
            catch (Throwable t) {
                String msg = "Recovering status information from '" + statePath + "' failed";
                FileResourceManager.this.logger.logSevere(msg, t);
                throw new ResourceManagerSystemException(msg, 1, this.txId, t);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        public synchronized String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.txId).append('\n');
            buf.append(Integer.toString(this.status)).append('\n');
            buf.append(Integer.toString(this.isolationLevel)).append('\n');
            buf.append(Long.toString(this.timeoutMSecs)).append('\n');
            buf.append(Long.toString(this.startTime)).append('\n');
            if (FileResourceManager.this.debug) {
                buf.append("----- Lock Debug Info -----\n");
                Iterator it = FileResourceManager.this.lockManager.getAll(this.txId).iterator();
                while (it.hasNext()) {
                    GenericLock lock = (GenericLock)it.next();
                    buf.append(lock.toString() + "\n");
                }
            }
            return buf.toString();
        }
    }
}

