/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.locking;

import java.util.Map;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.LockException;
import org.apache.commons.transaction.locking.ReadWriteLockManager;
import org.apache.commons.transaction.locking.ReadWriteUpgradeLock;
import org.apache.commons.transaction.util.LoggerFacade;

public class ReadWriteUpgradeLockManager
extends ReadWriteLockManager {
    public ReadWriteUpgradeLockManager(LoggerFacade logger, long timeoutMSecs) {
        super(3, logger, timeoutMSecs);
    }

    public boolean tryUpgradeLock(Object ownerId, Object resourceId) {
        return this.tryLock(ownerId, resourceId, 2, true);
    }

    public boolean tryWriteLock(Object ownerId, Object resourceId) {
        return this.tryLock(ownerId, resourceId, 3, true);
    }

    public void upgradeLock(Object ownerId, Object resourceId) throws LockException {
        super.lock(ownerId, resourceId, 2, true);
    }

    public void writeLock(Object ownerId, Object resourceId) throws LockException {
        super.lock(ownerId, resourceId, 3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericLock createLock(Object resourceId) {
        Map map = this.globalLocks;
        synchronized (map) {
            ReadWriteUpgradeLock lock = new ReadWriteUpgradeLock(resourceId, this.logger);
            this.globalLocks.put(resourceId, lock);
            return lock;
        }
    }
}

