/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.memory.jca;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.commons.transaction.memory.jca.MapConnectionSpec;

public class MapConnectionFactory
implements ConnectionFactory {
    Reference reference;
    ConnectionManager cm;
    ManagedConnectionFactory mcf;
    String name;

    public MapConnectionFactory(ManagedConnectionFactory mcf, ConnectionManager cm) {
        System.out.println("MCF Init with mcf " + mcf + " cm " + cm);
        this.mcf = mcf;
        this.cm = cm;
    }

    public Connection getConnection() throws ResourceException {
        throw new NotSupportedException("Need name of accessed map. Call getConnection(ConnectionSpec spec) instead");
    }

    public Connection getConnection(ConnectionSpec spec) throws ResourceException {
        if (!(spec instanceof MapConnectionSpec)) {
            throw new NotSupportedException("ConnectionSpec must be instance of MapConnectionSpec");
        }
        System.out.println("Getting connection with spec " + spec);
        return (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)((MapConnectionSpec)spec));
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        return null;
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return null;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() throws NamingException {
        return this.reference;
    }

    public String getName() {
        System.out.println("Getting name " + this.name);
        return this.name;
    }

    public void setName(String string) {
        System.out.println("Setting name " + string);
        this.name = string;
    }
}

